/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa;

import eu.dnetlib.broker.objects.OaBrokerRelatedPublication;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.broker.oa.util.ClusterUtils;
import eu.dnetlib.dhp.broker.oa.util.ConversionUtils;
import eu.dnetlib.dhp.broker.oa.util.aggregators.withRels.RelatedPublication;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Relation;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.FilterFunction;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.util.LongAccumulator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareRelatedPublicationsJob {
    private static final Logger log = LoggerFactory.getLogger(PrepareRelatedPublicationsJob.class);

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)PrepareRelatedPublicationsJob.class.getResourceAsStream("/eu/dnetlib/dhp/broker/oa/common_params.json")));
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Optional.ofNullable(parser.get("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String graphPath = parser.get("graphPath");
        log.info("graphPath: {}", (Object)graphPath);
        String rawRelsPath = parser.get("rawRelsPath");
        log.info("rawRelsPath: {}", (Object)rawRelsPath);
        String workingDir = parser.get("workingDir");
        log.info("workingDir: {}", (Object)workingDir);
        String relsPath = workingDir + "/relatedPublications";
        log.info("relsPath: {}", (Object)relsPath);
        SparkConf conf = new SparkConf();
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            ClusterUtils.removeDir(spark, relsPath);
            LongAccumulator total = spark.sparkContext().longAccumulator("total_rels");
            Dataset pubs = ClusterUtils.readPath(spark, graphPath + "/publication", Publication.class).filter((FilterFunction & Serializable)p -> !ClusterUtils.isDedupRoot(p.getId())).map(ConversionUtils::oafPublicationToBrokerPublication, Encoders.bean(OaBrokerRelatedPublication.class));
            Dataset rels = ClusterUtils.loadRawRelations(rawRelsPath, "resultResult", spark).filter((FilterFunction & Serializable)r -> ClusterUtils.isValidResultResultClass(r.getRelClass()));
            Dataset dataset = rels.joinWith(pubs, pubs.col("openaireId").equalTo((Object)rels.col("target")), "inner").map((MapFunction & Serializable)t -> {
                RelatedPublication rel = new RelatedPublication(((Relation)t._1).getSource(), (OaBrokerRelatedPublication)t._2);
                rel.getRelPublication().setRelType(((Relation)t._1).getRelClass());
                return rel;
            }, Encoders.bean(RelatedPublication.class));
            ClusterUtils.save(dataset, relsPath, RelatedPublication.class, total);
        });
    }
}

