/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.broker.objects.OaBrokerMainEntity;
import eu.dnetlib.pace.config.Config;
import eu.dnetlib.pace.config.DedupConfig;
import eu.dnetlib.pace.model.SparkDeduper;
import eu.dnetlib.pace.tree.support.TreeProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.spark.sql.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrustUtils {
    private static final Logger log = LoggerFactory.getLogger(TrustUtils.class);
    private static DedupConfig dedupConfig;
    private static SparkDeduper deduper;
    private static final ObjectMapper mapper;

    private TrustUtils() {
    }

    protected static float calculateTrust(OaBrokerMainEntity r1, OaBrokerMainEntity r2) {
        if (dedupConfig == null) {
            return 0.25f;
        }
        try {
            Row doc1 = deduper.model().rowFromJson(mapper.writeValueAsString((Object)r1));
            Row doc2 = deduper.model().rowFromJson(mapper.writeValueAsString((Object)r2));
            double score = new TreeProcessor((Config)dedupConfig).computeScore(doc1, doc2);
            double threshold = dedupConfig.getWf().getThreshold();
            return TrustUtils.rescale(score, threshold);
        }
        catch (Exception e) {
            log.error("Error computing score between results", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static float rescale(double score, double threshold) {
        if (score >= 1.0) {
            return 1.0f;
        }
        double val = (score - threshold) * 0.75 / (1.0 - threshold);
        if (val < 0.25) {
            return 0.25f;
        }
        if (val > 1.0) {
            return 1.0f;
        }
        return (float)val;
    }

    static {
        mapper = new ObjectMapper();
        try {
            dedupConfig = DedupConfig.load((String)IOUtils.toString((InputStream)DedupConfig.class.getResourceAsStream("/eu/dnetlib/dhp/broker/oa/dedupConfig/dedupConfig.json"), (Charset)StandardCharsets.UTF_8));
            deduper = new SparkDeduper(dedupConfig);
        }
        catch (IOException e) {
            log.error("Error loading dedupConfig, e");
        }
    }
}

