/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.broker.model.ConditionParams;
import eu.dnetlib.dhp.broker.model.Event;
import eu.dnetlib.dhp.broker.model.OaMappedFields;
import eu.dnetlib.dhp.broker.model.OaNotification;
import eu.dnetlib.dhp.broker.model.Subscription;
import eu.dnetlib.dhp.broker.oa.util.ClusterUtils;
import eu.dnetlib.dhp.broker.oa.util.OaNotificationGroup;
import eu.dnetlib.dhp.broker.oa.util.SubscriptionUtils;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.LongAccumulator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateNotificationsJob {
    private static final Logger log = LoggerFactory.getLogger(GenerateNotificationsJob.class);

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)GenerateNotificationsJob.class.getResourceAsStream("/eu/dnetlib/dhp/broker/oa/generate_notifications.json")));
        parser.parseArgument(args);
        SparkConf conf = new SparkConf();
        String eventsPath = parser.get("outputDir") + "/events";
        log.info("eventsPath: {}", (Object)eventsPath);
        String notificationsPath = parser.get("outputDir") + "/notifications";
        log.info("notificationsPath: {}", (Object)notificationsPath);
        String brokerApiBaseUrl = parser.get("brokerApiBaseUrl");
        log.info("brokerApiBaseUrl: {}", (Object)brokerApiBaseUrl);
        SparkSession spark = SparkSession.builder().config(conf).getOrCreate();
        LongAccumulator total = spark.sparkContext().longAccumulator("total_notifications");
        long startTime = new Date().getTime();
        List<Subscription> subscriptions = GenerateNotificationsJob.listSubscriptions(brokerApiBaseUrl);
        log.info("Number of subscriptions: " + subscriptions.size());
        if (subscriptions.size() > 0) {
            Map<String, Map<String, List<ConditionParams>>> conditionsMap = GenerateNotificationsJob.prepareConditionsMap(subscriptions);
            log.info("ConditionsMap: " + new ObjectMapper().writeValueAsString(conditionsMap));
            Encoder ngEncoder = Encoders.bean(OaNotificationGroup.class);
            Encoder nEncoder = Encoders.bean(OaNotification.class);
            Dataset notifications = ClusterUtils.readPath(spark, eventsPath, Event.class).map((MapFunction & Serializable)e -> GenerateNotificationsJob.generateNotifications(e, subscriptions, conditionsMap, startTime), ngEncoder).flatMap((FlatMapFunction & Serializable)g -> g.getData().iterator(), nEncoder);
            ClusterUtils.save(notifications, notificationsPath, OaNotification.class, total);
        }
    }

    protected static Map<String, Map<String, List<ConditionParams>>> prepareConditionsMap(List<Subscription> subscriptions) {
        HashMap<String, Map<String, List<ConditionParams>>> map = new HashMap<String, Map<String, List<ConditionParams>>>();
        subscriptions.forEach(s -> map.put(s.getSubscriptionId(), s.conditionsAsMap()));
        return map;
    }

    protected static OaNotificationGroup generateNotifications(Event e, List<Subscription> subscriptions, Map<String, Map<String, List<ConditionParams>>> conditionsMap, long date) {
        List<OaNotification> list = subscriptions.stream().filter(s -> StringUtils.isBlank((CharSequence)s.getTopic()) || "*".equals(s.getTopic()) || s.getTopic().equals(e.getTopic())).filter(s -> GenerateNotificationsJob.verifyConditions(e.getMap(), (Map)conditionsMap.get(s.getSubscriptionId()))).map(s -> GenerateNotificationsJob.generateNotification(s, e, date)).collect(Collectors.toList());
        return new OaNotificationGroup(list);
    }

    private static OaNotification generateNotification(Subscription s, Event e, long date) {
        OaNotification n = new OaNotification();
        n.setNotificationId("ntf-" + DigestUtils.md5Hex((String)(s.getSubscriptionId() + "@@@" + e.getEventId())));
        n.setSubscriptionId(s.getSubscriptionId());
        n.setEventId(e.getEventId());
        n.setProducerId(e.getProducerId());
        n.setTopic(e.getTopic());
        n.setPayload(e.getPayload());
        n.setMap(e.getMap());
        n.setDate(date);
        return n;
    }

    private static boolean verifyConditions(OaMappedFields map, Map<String, List<ConditionParams>> conditions) {
        if (conditions.containsKey("targetDatasourceName") && !SubscriptionUtils.verifyExact(map.getTargetDatasourceName(), conditions.get("targetDatasourceName").get(0).getValue()) || conditions.containsKey("trust") && !SubscriptionUtils.verifyFloatRange(map.getTrust(), conditions.get("trust").get(0).getValue(), conditions.get("trust").get(0).getOtherValue())) {
            return false;
        }
        if (conditions.containsKey("targetDateofacceptance") && !conditions.get("targetDateofacceptance").stream().anyMatch(c -> SubscriptionUtils.verifyDateRange(map.getTargetDateofacceptance(), c.getValue(), c.getOtherValue())) || conditions.containsKey("targetResultTitle") && !conditions.get("targetResultTitle").stream().anyMatch(c -> SubscriptionUtils.verifySimilar(map.getTargetResultTitle(), c.getValue()))) {
            return false;
        }
        if (conditions.containsKey("targetAuthors") && !conditions.get("targetAuthors").stream().allMatch(c -> SubscriptionUtils.verifyListSimilar(map.getTargetAuthors(), c.getValue()))) {
            return false;
        }
        return !conditions.containsKey("targetSubjects") || conditions.get("targetSubjects").stream().allMatch(c -> SubscriptionUtils.verifyListExact(map.getTargetSubjects(), c.getValue()));
    }

    /*
     * Exception decompiling
     */
    private static List<Subscription> listSubscriptions(String brokerApiBaseUrl) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

