/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa.util;

import eu.dnetlib.dhp.broker.oa.util.ConversionUtils;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Result;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import scala.Tuple3;

public class DatasourceRelationsAccumulator
implements Serializable {
    private static final long serialVersionUID = 3256220670651218957L;
    private List<Tuple3<String, String, String>> rels = new ArrayList<Tuple3<String, String, String>>();

    public List<Tuple3<String, String, String>> getRels() {
        return this.rels;
    }

    public void setRels(List<Tuple3<String, String, String>> rels) {
        this.rels = rels;
    }

    protected void addTuple(Tuple3<String, String, String> t) {
        this.rels.add(t);
    }

    public static final DatasourceRelationsAccumulator calculateTuples(Result r) {
        Set collectedFromSet = r.getCollectedfrom().stream().map(KeyValue::getKey).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toSet());
        Set hostedBySet = r.getInstance().stream().map(Instance::getHostedby).filter(Objects::nonNull).filter(kv -> !StringUtils.equalsIgnoreCase((CharSequence)kv.getValue(), (CharSequence)"Unknown Repository")).map(KeyValue::getKey).filter(StringUtils::isNotBlank).distinct().filter(id -> !collectedFromSet.contains(id)).collect(Collectors.toSet());
        DatasourceRelationsAccumulator res = new DatasourceRelationsAccumulator();
        collectedFromSet.stream().map(s -> new Tuple3((Object)ConversionUtils.cleanOpenaireId(r.getId()), (Object)ConversionUtils.cleanOpenaireId(s), (Object)"collectedFrom")).forEach(res::addTuple);
        hostedBySet.stream().map(s -> new Tuple3((Object)ConversionUtils.cleanOpenaireId(r.getId()), (Object)ConversionUtils.cleanOpenaireId(s), (Object)"hostedBy")).forEach(res::addTuple);
        return res;
    }
}

