/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa.util;

import eu.dnetlib.broker.objects.OaBrokerMainEntity;
import eu.dnetlib.broker.objects.OaBrokerRelatedDatasource;
import eu.dnetlib.dhp.broker.model.EventFactory;
import eu.dnetlib.dhp.broker.oa.matchers.UpdateMatcher;
import eu.dnetlib.dhp.broker.oa.matchers.relatedDatasets.EnrichMissingDatasetIsReferencedBy;
import eu.dnetlib.dhp.broker.oa.matchers.relatedDatasets.EnrichMissingDatasetIsRelatedTo;
import eu.dnetlib.dhp.broker.oa.matchers.relatedDatasets.EnrichMissingDatasetIsSupplementedBy;
import eu.dnetlib.dhp.broker.oa.matchers.relatedDatasets.EnrichMissingDatasetIsSupplementedTo;
import eu.dnetlib.dhp.broker.oa.matchers.relatedDatasets.EnrichMissingDatasetReferences;
import eu.dnetlib.dhp.broker.oa.matchers.relatedProjects.EnrichMissingProject;
import eu.dnetlib.dhp.broker.oa.matchers.relatedProjects.EnrichMoreProject;
import eu.dnetlib.dhp.broker.oa.matchers.relatedPublications.EnrichMissingPublicationIsReferencedBy;
import eu.dnetlib.dhp.broker.oa.matchers.relatedPublications.EnrichMissingPublicationIsRelatedTo;
import eu.dnetlib.dhp.broker.oa.matchers.relatedPublications.EnrichMissingPublicationIsSupplementedBy;
import eu.dnetlib.dhp.broker.oa.matchers.relatedPublications.EnrichMissingPublicationIsSupplementedTo;
import eu.dnetlib.dhp.broker.oa.matchers.relatedPublications.EnrichMissingPublicationReferences;
import eu.dnetlib.dhp.broker.oa.matchers.relatedSoftware.EnrichMissingSoftware;
import eu.dnetlib.dhp.broker.oa.matchers.relatedSoftware.EnrichMoreSoftware;
import eu.dnetlib.dhp.broker.oa.matchers.simple.EnrichMissingAbstract;
import eu.dnetlib.dhp.broker.oa.matchers.simple.EnrichMissingAuthorOrcid;
import eu.dnetlib.dhp.broker.oa.matchers.simple.EnrichMissingOpenAccess;
import eu.dnetlib.dhp.broker.oa.matchers.simple.EnrichMissingPid;
import eu.dnetlib.dhp.broker.oa.matchers.simple.EnrichMissingPublicationDate;
import eu.dnetlib.dhp.broker.oa.matchers.simple.EnrichMissingSubject;
import eu.dnetlib.dhp.broker.oa.matchers.simple.EnrichMoreOpenAccess;
import eu.dnetlib.dhp.broker.oa.matchers.simple.EnrichMorePid;
import eu.dnetlib.dhp.broker.oa.matchers.simple.EnrichMoreSubject;
import eu.dnetlib.dhp.broker.oa.util.EventGroup;
import eu.dnetlib.dhp.broker.oa.util.UpdateInfo;
import eu.dnetlib.dhp.broker.oa.util.aggregators.simple.ResultGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.spark.util.LongAccumulator;

public class EventFinder {
    private static final List<UpdateMatcher<?>> matchers = new ArrayList();

    private EventFinder() {
    }

    public static EventGroup generateEvents(ResultGroup results, Set<String> dsIdWhitelist, Set<String> dsIdBlacklist, Set<String> dsTypeWhitelist, Set<String> topicWhitelist, Map<String, LongAccumulator> accumulators) {
        ArrayList list = new ArrayList();
        for (OaBrokerMainEntity target : results.getData()) {
            for (OaBrokerRelatedDatasource targetDs : target.getDatasources()) {
                if (!EventFinder.verifyTarget(targetDs, dsIdWhitelist, dsIdBlacklist, dsTypeWhitelist)) continue;
                for (UpdateMatcher<?> matcher : matchers) {
                    for (UpdateInfo<?> info : matcher.searchUpdatesForRecord(target, targetDs, results.getData(), accumulators)) {
                        if (topicWhitelist != null && !topicWhitelist.isEmpty() && !topicWhitelist.contains(info.getTopic().getPath())) continue;
                        list.add(info);
                    }
                }
            }
        }
        return EventFinder.asEventGroup(list);
    }

    private static boolean verifyTarget(OaBrokerRelatedDatasource target, Set<String> dsIdWhitelist, Set<String> dsIdBlacklist, Set<String> dsTypeWhitelist) {
        if (dsIdWhitelist.contains(target.getOpenaireId())) {
            return true;
        }
        if (dsIdBlacklist.contains(target.getOpenaireId())) {
            return false;
        }
        return dsTypeWhitelist.contains(target.getType());
    }

    private static EventGroup asEventGroup(List<UpdateInfo<?>> list) {
        EventGroup events = new EventGroup();
        list.stream().map(EventFactory::newBrokerEvent).forEach(events::addElement);
        return events;
    }

    public static List<UpdateMatcher<?>> getMatchers() {
        return matchers;
    }

    static {
        matchers.add(new EnrichMissingAbstract());
        matchers.add(new EnrichMissingAuthorOrcid());
        matchers.add(new EnrichMissingOpenAccess());
        matchers.add(new EnrichMissingPid());
        matchers.add(new EnrichMissingPublicationDate());
        matchers.add(new EnrichMissingSubject());
        matchers.add(new EnrichMoreOpenAccess());
        matchers.add(new EnrichMorePid());
        matchers.add(new EnrichMoreSubject());
        matchers.add(new EnrichMissingProject());
        matchers.add(new EnrichMoreProject());
        matchers.add(new EnrichMissingSoftware());
        matchers.add(new EnrichMoreSoftware());
        matchers.add(new EnrichMissingPublicationIsRelatedTo());
        matchers.add(new EnrichMissingPublicationIsReferencedBy());
        matchers.add(new EnrichMissingPublicationReferences());
        matchers.add(new EnrichMissingPublicationIsSupplementedTo());
        matchers.add(new EnrichMissingPublicationIsSupplementedBy());
        matchers.add(new EnrichMissingDatasetIsRelatedTo());
        matchers.add(new EnrichMissingDatasetIsReferencedBy());
        matchers.add(new EnrichMissingDatasetReferences());
        matchers.add(new EnrichMissingDatasetIsSupplementedTo());
        matchers.add(new EnrichMissingDatasetIsSupplementedBy());
    }
}

