/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.broker.model.Event;
import eu.dnetlib.dhp.broker.oa.util.ClusterUtils;
import eu.dnetlib.dhp.broker.oa.util.EventGroup;
import eu.dnetlib.dhp.broker.oa.util.aggregators.subset.EventSubsetAggregator;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.TypedColumn;
import org.apache.spark.util.LongAccumulator;
import org.elasticsearch.spark.rdd.api.java.JavaEsSpark;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexEventSubsetJob {
    private static final Logger log = LoggerFactory.getLogger(IndexEventSubsetJob.class);

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)IndexEventSubsetJob.class.getResourceAsStream("/eu/dnetlib/dhp/broker/oa/index_event_subset.json")));
        parser.parseArgument(args);
        SparkConf conf = new SparkConf();
        String eventsPath = parser.get("outputDir") + "/events";
        log.info("eventsPath: {}", (Object)eventsPath);
        String index = parser.get("index");
        log.info("index: {}", (Object)index);
        String indexHost = parser.get("esHost");
        log.info("indexHost: {}", (Object)indexHost);
        String esBatchWriteRetryCount = parser.get("esBatchWriteRetryCount");
        log.info("esBatchWriteRetryCount: {}", (Object)esBatchWriteRetryCount);
        String esBatchWriteRetryWait = parser.get("esBatchWriteRetryWait");
        log.info("esBatchWriteRetryWait: {}", (Object)esBatchWriteRetryWait);
        String esBatchSizeEntries = parser.get("esBatchSizeEntries");
        log.info("esBatchSizeEntries: {}", (Object)esBatchSizeEntries);
        String esNodesWanOnly = parser.get("esNodesWanOnly");
        log.info("esNodesWanOnly: {}", (Object)esNodesWanOnly);
        int maxEventsForTopic = NumberUtils.toInt((String)parser.get("maxEventsForTopic"));
        log.info("maxEventsForTopic: {}", (Object)maxEventsForTopic);
        String brokerApiBaseUrl = parser.get("brokerApiBaseUrl");
        log.info("brokerApiBaseUrl: {}", (Object)brokerApiBaseUrl);
        SparkSession spark = SparkSession.builder().config(conf).getOrCreate();
        TypedColumn aggr = new EventSubsetAggregator(maxEventsForTopic).toColumn();
        LongAccumulator total = spark.sparkContext().longAccumulator("total_indexed");
        long now = new Date().getTime();
        Dataset subset = ClusterUtils.readPath(spark, eventsPath, Event.class).groupByKey((MapFunction & Serializable)e -> e.getTopic() + '@' + e.getMap().getTargetDatasourceId(), Encoders.STRING()).agg(aggr).map((MapFunction & Serializable)t -> (EventGroup)t._2, Encoders.bean(EventGroup.class)).flatMap((FlatMapFunction & Serializable)g -> g.getData().iterator(), Encoders.bean(Event.class));
        JavaRDD inputRdd = subset.map((MapFunction & Serializable)e -> IndexEventSubsetJob.prepareEventForIndexing(e, now, total), Encoders.STRING()).javaRDD();
        HashMap<String, String> esCfg = new HashMap<String, String>();
        esCfg.put("es.index.auto.create", "false");
        esCfg.put("es.nodes", indexHost);
        esCfg.put("es.mapping.id", "eventId");
        esCfg.put("es.batch.write.retry.count", esBatchWriteRetryCount);
        esCfg.put("es.batch.write.retry.wait", esBatchWriteRetryWait);
        esCfg.put("es.batch.size.entries", esBatchSizeEntries);
        esCfg.put("es.nodes.wan.only", esNodesWanOnly);
        log.info("*** Start indexing");
        JavaEsSpark.saveJsonToEs((JavaRDD)inputRdd, (String)index, esCfg);
        log.info("*** End indexing");
        log.info("*** Deleting old events");
        String message = IndexEventSubsetJob.deleteOldEvents(brokerApiBaseUrl, now - 1000L);
        log.info("*** Deleted events: {}", (Object)message);
    }

    /*
     * Exception decompiling
     */
    private static String deleteOldEvents(String brokerApiBaseUrl, long l) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String prepareEventForIndexing(Event e, long creationDate, LongAccumulator acc) throws JsonProcessingException {
        acc.add(1L);
        e.setCreationDate(creationDate);
        e.setExpiryDate(Long.MAX_VALUE);
        return new ObjectMapper().writeValueAsString((Object)e);
    }
}

