/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.broker.model.Notification;
import eu.dnetlib.dhp.broker.oa.util.ClusterUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.LongAccumulator;
import org.elasticsearch.spark.rdd.api.java.JavaEsSpark;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexNotificationsJob {
    private static final Logger log = LoggerFactory.getLogger(IndexNotificationsJob.class);

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)IndexNotificationsJob.class.getResourceAsStream("/eu/dnetlib/dhp/broker/oa/index_notifications.json")));
        parser.parseArgument(args);
        SparkConf conf = new SparkConf();
        String notificationsPath = parser.get("outputDir") + "/notifications";
        log.info("notificationsPath: {}", (Object)notificationsPath);
        String index = parser.get("index");
        log.info("index: {}", (Object)index);
        String indexHost = parser.get("esHost");
        log.info("indexHost: {}", (Object)indexHost);
        String esBatchWriteRetryCount = parser.get("esBatchWriteRetryCount");
        log.info("esBatchWriteRetryCount: {}", (Object)esBatchWriteRetryCount);
        String esBatchWriteRetryWait = parser.get("esBatchWriteRetryWait");
        log.info("esBatchWriteRetryWait: {}", (Object)esBatchWriteRetryWait);
        String esBatchSizeEntries = parser.get("esBatchSizeEntries");
        log.info("esBatchSizeEntries: {}", (Object)esBatchSizeEntries);
        String esNodesWanOnly = parser.get("esNodesWanOnly");
        log.info("esNodesWanOnly: {}", (Object)esNodesWanOnly);
        String brokerApiBaseUrl = parser.get("brokerApiBaseUrl");
        log.info("brokerApiBaseUrl: {}", (Object)brokerApiBaseUrl);
        SparkSession spark = SparkSession.builder().config(conf).getOrCreate();
        LongAccumulator total = spark.sparkContext().longAccumulator("total_indexed");
        Long date = ((Notification)ClusterUtils.readPath(spark, notificationsPath, Notification.class).first()).getDate();
        JavaRDD toIndexRdd = ClusterUtils.readPath(spark, notificationsPath, Notification.class).map((MapFunction & Serializable)n -> IndexNotificationsJob.prepareForIndexing(n, total), Encoders.STRING()).javaRDD();
        HashMap<String, String> esCfg = new HashMap<String, String>();
        esCfg.put("es.index.auto.create", "false");
        esCfg.put("es.nodes", indexHost);
        esCfg.put("es.mapping.id", "notificationId");
        esCfg.put("es.batch.write.retry.count", esBatchWriteRetryCount);
        esCfg.put("es.batch.write.retry.wait", esBatchWriteRetryWait);
        esCfg.put("es.batch.size.entries", esBatchSizeEntries);
        esCfg.put("es.nodes.wan.only", esNodesWanOnly);
        log.info("*** Start indexing");
        JavaEsSpark.saveJsonToEs((JavaRDD)toIndexRdd, (String)index, esCfg);
        log.info("*** End indexing");
        log.info("*** Deleting old notifications");
        String message = IndexNotificationsJob.deleteOldNotifications(brokerApiBaseUrl, date - 1000L);
        log.info("*** Deleted notifications: {}", (Object)message);
        log.info("*** sendNotifications (emails, ...)");
        IndexNotificationsJob.sendNotifications(brokerApiBaseUrl, date - 1000L);
        log.info("*** ALL done.");
    }

    /*
     * Exception decompiling
     */
    private static String deleteOldNotifications(String brokerApiBaseUrl, long l) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static String sendNotifications(String brokerApiBaseUrl, long l) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static String prepareForIndexing(Notification n, LongAccumulator acc) throws JsonProcessingException {
        acc.add(1L);
        return new ObjectMapper().writeValueAsString((Object)n);
    }
}

