/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa.util;

import eu.dnetlib.broker.objects.OaBrokerAuthor;
import eu.dnetlib.broker.objects.OaBrokerExternalReference;
import eu.dnetlib.broker.objects.OaBrokerInstance;
import eu.dnetlib.broker.objects.OaBrokerJournal;
import eu.dnetlib.broker.objects.OaBrokerMainEntity;
import eu.dnetlib.broker.objects.OaBrokerProject;
import eu.dnetlib.broker.objects.OaBrokerRelatedDataset;
import eu.dnetlib.broker.objects.OaBrokerRelatedDatasource;
import eu.dnetlib.broker.objects.OaBrokerRelatedPublication;
import eu.dnetlib.broker.objects.OaBrokerRelatedSoftware;
import eu.dnetlib.broker.objects.OaBrokerTypedValue;
import eu.dnetlib.dhp.schema.oaf.Author;
import eu.dnetlib.dhp.schema.oaf.Dataset;
import eu.dnetlib.dhp.schema.oaf.Datasource;
import eu.dnetlib.dhp.schema.oaf.ExternalReference;
import eu.dnetlib.dhp.schema.oaf.Field;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.Journal;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Project;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.Software;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.dhp.schema.oaf.Subject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConversionUtils {
    private static final Logger log = LoggerFactory.getLogger(ConversionUtils.class);

    private ConversionUtils() {
    }

    public static List<OaBrokerInstance> oafInstanceToBrokerInstances(Instance i) {
        if (i == null) {
            return new ArrayList<OaBrokerInstance>();
        }
        return ConversionUtils.mappedList(i.getUrl(), url -> {
            OaBrokerInstance res = new OaBrokerInstance();
            res.setUrl(url);
            res.setInstancetype(ConversionUtils.classId(i.getInstancetype()));
            res.setLicense("OPEN");
            res.setHostedby(ConversionUtils.kvValue(i.getHostedby()));
            return res;
        });
    }

    public static OaBrokerTypedValue oafPidToBrokerPid(StructuredProperty sp) {
        return ConversionUtils.oafStructPropToBrokerTypedValue(sp);
    }

    public static OaBrokerTypedValue oafStructPropToBrokerTypedValue(StructuredProperty sp) {
        return sp != null ? new OaBrokerTypedValue(ConversionUtils.classId(sp.getQualifier()), sp.getValue()) : null;
    }

    public static OaBrokerTypedValue oafSubjectToBrokerTypedValue(Subject sp) {
        return sp != null ? new OaBrokerTypedValue(ConversionUtils.classId(sp.getQualifier()), sp.getValue()) : null;
    }

    public static OaBrokerRelatedDataset oafDatasetToBrokerDataset(Dataset d) {
        if (d == null) {
            return null;
        }
        OaBrokerRelatedDataset res = new OaBrokerRelatedDataset();
        res.setOpenaireId(ConversionUtils.cleanOpenaireId(d.getId()));
        res.setOriginalId(ConversionUtils.first(d.getOriginalId()));
        res.setTitle(ConversionUtils.structPropValue(d.getTitle()));
        res.setPids(ConversionUtils.allResultPids((Result)d));
        res.setInstances(ConversionUtils.flatMappedList(d.getInstance(), ConversionUtils::oafInstanceToBrokerInstances));
        res.setCollectedFrom(ConversionUtils.mappedFirst(d.getCollectedfrom(), KeyValue::getValue));
        return res;
    }

    public static OaBrokerRelatedPublication oafPublicationToBrokerPublication(Publication p) {
        if (p == null) {
            return null;
        }
        OaBrokerRelatedPublication res = new OaBrokerRelatedPublication();
        res.setOpenaireId(ConversionUtils.cleanOpenaireId(p.getId()));
        res.setOriginalId(ConversionUtils.first(p.getOriginalId()));
        res.setTitle(ConversionUtils.structPropValue(p.getTitle()));
        res.setPids(ConversionUtils.allResultPids((Result)p));
        res.setInstances(ConversionUtils.flatMappedList(p.getInstance(), ConversionUtils::oafInstanceToBrokerInstances));
        res.setCollectedFrom(ConversionUtils.mappedFirst(p.getCollectedfrom(), KeyValue::getValue));
        return res;
    }

    public static OaBrokerMainEntity oafResultToBrokerResult(Result result) {
        if (result == null) {
            return null;
        }
        OaBrokerMainEntity res = new OaBrokerMainEntity();
        res.setOpenaireId(ConversionUtils.cleanOpenaireId(result.getId()));
        res.setOriginalId(ConversionUtils.first(result.getOriginalId()));
        res.setTypology(ConversionUtils.classId(result.getResulttype()));
        res.setTitles(ConversionUtils.structPropList(result.getTitle()));
        res.setAbstracts(ConversionUtils.fieldList(result.getDescription()));
        res.setLanguage(ConversionUtils.classId(result.getLanguage()));
        res.setSubjects(ConversionUtils.subjectList(result.getSubject()));
        res.setCreators(ConversionUtils.mappedList(result.getAuthor(), ConversionUtils::oafAuthorToBrokerAuthor));
        res.setPublicationdate(ConversionUtils.fieldValue((Field<String>)result.getDateofacceptance()));
        res.setPublisher(ConversionUtils.fieldValue((Field<String>)result.getPublisher()));
        res.setEmbargoenddate(ConversionUtils.fieldValue((Field<String>)result.getEmbargoenddate()));
        res.setContributor(ConversionUtils.fieldList(result.getContributor()));
        res.setJournal(result instanceof Publication ? ConversionUtils.oafJournalToBrokerJournal(((Publication)result).getJournal()) : null);
        res.setPids(ConversionUtils.allResultPids(result));
        res.setInstances(ConversionUtils.flatMappedList(result.getInstance(), ConversionUtils::oafInstanceToBrokerInstances));
        res.setExternalReferences(ConversionUtils.mappedList(result.getExternalReference(), ConversionUtils::oafExtRefToBrokerExtRef));
        return res;
    }

    protected static List<OaBrokerTypedValue> allResultPids(Result result) {
        HashMap map = new HashMap();
        if (result.getPid() != null) {
            result.getPid().forEach(sp -> map.put(sp.getValue(), sp));
        }
        if (result.getInstance() != null) {
            result.getInstance().forEach(i -> {
                if (i.getPid() != null) {
                    i.getPid().forEach(sp -> map.put(sp.getValue(), sp));
                }
                if (i.getAlternateIdentifier() != null) {
                    i.getAlternateIdentifier().forEach(sp -> map.put(sp.getValue(), sp));
                }
            });
        }
        return ConversionUtils.mappedList(map.values(), ConversionUtils::oafPidToBrokerPid);
    }

    public static String cleanOpenaireId(String id) {
        return id.contains("|") ? StringUtils.substringAfter((String)id, (String)"|") : id;
    }

    private static OaBrokerAuthor oafAuthorToBrokerAuthor(Author author) {
        if (author == null) {
            return null;
        }
        String pids = author.getPid() != null ? (String)author.getPid().stream().filter(Objects::nonNull).filter(pid -> pid.getQualifier() != null).filter(pid -> pid.getQualifier().getClassid() != null).filter(pid -> pid.getQualifier().getClassid().equalsIgnoreCase("orcid")).map(StructuredProperty::getValue).map(ConversionUtils::cleanOrcid).filter(StringUtils::isNotBlank).findFirst().orElse(null) : null;
        return new OaBrokerAuthor(author.getFullname(), pids);
    }

    private static String cleanOrcid(String s) {
        String match = "//orcid.org/";
        return s.contains("//orcid.org/") ? StringUtils.substringAfter((String)s, (String)"//orcid.org/") : s;
    }

    private static OaBrokerJournal oafJournalToBrokerJournal(Journal journal) {
        if (journal == null) {
            return null;
        }
        OaBrokerJournal res = new OaBrokerJournal();
        res.setName(journal.getName());
        res.setIssn(journal.getIssnPrinted());
        res.setEissn(journal.getIssnOnline());
        res.setLissn(journal.getIssnLinking());
        return res;
    }

    private static OaBrokerExternalReference oafExtRefToBrokerExtRef(ExternalReference ref) {
        if (ref == null) {
            return null;
        }
        OaBrokerExternalReference res = new OaBrokerExternalReference();
        res.setRefidentifier(ref.getRefidentifier());
        res.setSitename(ref.getSitename());
        res.setType(ConversionUtils.classId(ref.getQualifier()));
        res.setUrl(ref.getUrl());
        return res;
    }

    public static OaBrokerProject oafProjectToBrokerProject(Project p) {
        if (p == null) {
            return null;
        }
        OaBrokerProject res = new OaBrokerProject();
        res.setOpenaireId(ConversionUtils.cleanOpenaireId(p.getId()));
        res.setTitle(ConversionUtils.fieldValue((Field<String>)p.getTitle()));
        res.setAcronym(ConversionUtils.fieldValue((Field<String>)p.getAcronym()));
        res.setCode(ConversionUtils.fieldValue((Field<String>)p.getCode()));
        String ftree = ConversionUtils.fieldValue(p.getFundingtree());
        if (StringUtils.isNotBlank((CharSequence)ftree)) {
            try {
                Document fdoc = DocumentHelper.parseText((String)ftree);
                res.setFunder(fdoc.valueOf("/fundingtree/funder/shortname"));
                res.setJurisdiction(fdoc.valueOf("/fundingtree/funder/jurisdiction"));
                res.setFundingProgram(fdoc.valueOf("//funding_level_0/name"));
            }
            catch (DocumentException e) {
                log.error("Error in record {}: invalid fundingtree: {}", (Object)p.getId(), (Object)ftree);
            }
        }
        return res;
    }

    public static OaBrokerRelatedSoftware oafSoftwareToBrokerSoftware(Software sw) {
        if (sw == null) {
            return null;
        }
        OaBrokerRelatedSoftware res = new OaBrokerRelatedSoftware();
        res.setOpenaireId(ConversionUtils.cleanOpenaireId(sw.getId()));
        res.setName(ConversionUtils.structPropValue(sw.getTitle()));
        res.setDescription(ConversionUtils.fieldValue(sw.getDescription()));
        res.setRepository(ConversionUtils.fieldValue((Field<String>)sw.getCodeRepositoryUrl()));
        res.setLandingPage(ConversionUtils.fieldValue(sw.getDocumentationUrl()));
        return res;
    }

    public static OaBrokerRelatedDatasource oafDatasourceToBrokerDatasource(Datasource ds) {
        if (ds == null) {
            return null;
        }
        OaBrokerRelatedDatasource res = new OaBrokerRelatedDatasource();
        res.setName((String)StringUtils.defaultIfBlank((CharSequence)ConversionUtils.fieldValue((Field<String>)ds.getOfficialname()), (CharSequence)ConversionUtils.fieldValue((Field<String>)ds.getEnglishname())));
        res.setOpenaireId(ConversionUtils.cleanOpenaireId(ds.getId()));
        res.setType(ConversionUtils.classId(ds.getDatasourcetype()));
        return res;
    }

    private static String first(List<String> list) {
        return list != null && !list.isEmpty() ? list.get(0) : null;
    }

    private static String kvValue(KeyValue kv) {
        return kv != null ? kv.getValue() : null;
    }

    private static String fieldValue(Field<String> f) {
        return f != null ? (String)f.getValue() : null;
    }

    private static String fieldValue(List<Field<String>> fl) {
        return fl != null ? (String)fl.stream().map(Field::getValue).filter(StringUtils::isNotBlank).findFirst().orElse(null) : null;
    }

    private static String classId(Qualifier q) {
        return q != null ? q.getClassid() : null;
    }

    private static String structPropValue(List<StructuredProperty> props) {
        return props != null ? (String)props.stream().map(StructuredProperty::getValue).filter(StringUtils::isNotBlank).findFirst().orElse(null) : null;
    }

    private static List<String> fieldList(List<Field<String>> fl) {
        return fl != null ? fl.stream().map(Field::getValue).map(s -> StringUtils.abbreviate((String)s, (int)3000)).filter(StringUtils::isNotBlank).limit(50L).collect(Collectors.toList()) : new ArrayList<String>();
    }

    private static List<String> structPropList(List<StructuredProperty> props) {
        return props != null ? props.stream().map(StructuredProperty::getValue).filter(StringUtils::isNotBlank).limit(50L).collect(Collectors.toList()) : new ArrayList<String>();
    }

    private static List<OaBrokerTypedValue> subjectList(List<Subject> list) {
        if (list == null) {
            return new ArrayList<OaBrokerTypedValue>();
        }
        return list.stream().map(ConversionUtils::oafSubjectToBrokerTypedValue).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static List<OaBrokerTypedValue> structPropTypedList(List<StructuredProperty> list) {
        if (list == null) {
            return new ArrayList<OaBrokerTypedValue>();
        }
        return list.stream().map(ConversionUtils::oafStructPropToBrokerTypedValue).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static <F, T> List<T> mappedList(Collection<F> list, Function<F, T> func) {
        if (list == null) {
            return new ArrayList();
        }
        return list.stream().map(func::apply).filter(Objects::nonNull).limit(50L).collect(Collectors.toList());
    }

    private static <F, T> List<T> flatMappedList(List<F> list, Function<F, List<T>> func) {
        if (list == null) {
            return new ArrayList();
        }
        return list.stream().map(func::apply).flatMap(Collection::stream).filter(Objects::nonNull).limit(50L).collect(Collectors.toList());
    }

    private static <F, T> T mappedFirst(List<F> list, Function<F, T> func) {
        if (list == null) {
            return null;
        }
        return list.stream().map(func::apply).filter(Objects::nonNull).findFirst().orElse(null);
    }
}

