/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.blacklist;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.blacklist.SparkRemoveBlacklistedRelationJob;
import eu.dnetlib.dhp.schema.oaf.Relation;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlackListTest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final ClassLoader cl = BlackListTest.class.getClassLoader();
    private static SparkSession spark;
    private static Path workingDir;
    private static final Logger log;

    @BeforeAll
    public static void beforeAll() throws IOException {
        workingDir = Files.createTempDirectory(BlackListTest.class.getSimpleName(), new FileAttribute[0]);
        log.info("using work dir {}", (Object)workingDir);
        SparkConf conf = new SparkConf();
        conf.setAppName(BlackListTest.class.getSimpleName());
        conf.setMaster("local[*]");
        conf.set("spark.driver.host", "localhost");
        conf.set("hive.metastore.local", "true");
        conf.set("spark.ui.enabled", "false");
        conf.set("spark.sql.warehouse.dir", workingDir.toString());
        conf.set("hive.metastore.warehouse.dir", workingDir.resolve("warehouse").toString());
        spark = SparkSession.builder().appName(BlackListTest.class.getSimpleName()).config(conf).getOrCreate();
    }

    @AfterAll
    public static void afterAll() throws IOException {
        FileUtils.deleteDirectory((File)workingDir.toFile());
        spark.stop();
    }

    @Test
    void noRemoveTest() throws Exception {
        SparkRemoveBlacklistedRelationJob.main((String[])new String[]{"-isSparkSessionManaged", Boolean.FALSE.toString(), "-sourcePath", this.getClass().getResource("/eu/dnetlib/dhp/blacklist/relationsNoRemoval").getPath(), "-outputPath", workingDir.toString() + "/relation", "-hdfsPath", this.getClass().getResource("/eu/dnetlib/dhp/blacklist/blacklist").getPath(), "-mergesPath", this.getClass().getResource("/eu/dnetlib/dhp/blacklist/mergesRel").getPath()});
        JavaSparkContext sc = new JavaSparkContext(spark.sparkContext());
        JavaRDD tmp = sc.textFile(workingDir.toString() + "/relation").map((Function & Serializable)item -> (Relation)OBJECT_MAPPER.readValue(item, Relation.class));
        Assertions.assertEquals((long)13L, (long)tmp.count());
    }

    @Test
    void removeNoMergeMatchTest() throws Exception {
        SparkRemoveBlacklistedRelationJob.main((String[])new String[]{"-isSparkSessionManaged", Boolean.FALSE.toString(), "-sourcePath", this.getClass().getResource("/eu/dnetlib/dhp/blacklist/relationsOneRemoval").getPath(), "-outputPath", workingDir.toString() + "/relation", "-hdfsPath", this.getClass().getResource("/eu/dnetlib/dhp/blacklist/blacklist").getPath(), "-mergesPath", this.getClass().getResource("/eu/dnetlib/dhp/blacklist/mergesRel").getPath()});
        JavaSparkContext sc = new JavaSparkContext(spark.sparkContext());
        JavaRDD tmp = sc.textFile(workingDir.toString() + "/relation").map((Function & Serializable)item -> (Relation)OBJECT_MAPPER.readValue(item, Relation.class));
        Assertions.assertEquals((long)12L, (long)tmp.count());
        Dataset verificationDataset = spark.createDataset(tmp.rdd(), Encoders.bean(Relation.class));
        Assertions.assertEquals((long)0L, (long)verificationDataset.filter("source = '40|corda__h2020::5161f53ab205d803c36b4c888fe7deef' and target = '20|dedup_wf_001::157af406bc653aa4d9749318b644de43'").count());
        Assertions.assertEquals((long)0L, (long)verificationDataset.filter("relClass = 'hasParticipant'").count());
    }

    @Test
    void removeMergeMatchTest() throws Exception {
        SparkRemoveBlacklistedRelationJob.main((String[])new String[]{"-isSparkSessionManaged", Boolean.FALSE.toString(), "-sourcePath", this.getClass().getResource("/eu/dnetlib/dhp/blacklist/relationOneRemovalWithMatch").getPath(), "-outputPath", workingDir.toString() + "/relation", "-hdfsPath", this.getClass().getResource("/eu/dnetlib/dhp/blacklist/blacklist").getPath(), "-mergesPath", this.getClass().getResource("/eu/dnetlib/dhp/blacklist/mergesRelOneMerge").getPath()});
        JavaSparkContext sc = new JavaSparkContext(spark.sparkContext());
        JavaRDD tmp = sc.textFile(workingDir.toString() + "/relation").map((Function & Serializable)item -> (Relation)OBJECT_MAPPER.readValue(item, Relation.class));
        Assertions.assertEquals((long)12L, (long)tmp.count());
        Dataset verificationDataset = spark.createDataset(tmp.rdd(), Encoders.bean(Relation.class));
        Assertions.assertEquals((long)12L, (long)verificationDataset.filter("relClass = 'isProvidedBy'").count());
    }

    static {
        log = LoggerFactory.getLogger(BlackListTest.class);
    }
}

