/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.blacklist;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.DbClient;
import eu.dnetlib.dhp.schema.common.ModelSupport;
import eu.dnetlib.dhp.schema.common.RelationInverse;
import eu.dnetlib.dhp.schema.oaf.Relation;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class ReadBlacklistFromDB
implements Closeable {
    private final DbClient dbClient;
    private static final Log log = LogFactory.getLog(ReadBlacklistFromDB.class);
    private final Configuration conf;
    private final BufferedWriter writer;
    private final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String query = "SELECT source_type, unnest(original_source_objects) as source, target_type, unnest(original_target_objects) as target, relationship FROM blacklist WHERE status = 'ACCEPTED'";

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)ReadBlacklistFromDB.class.getResourceAsStream("/eu/dnetlib/dhp/blacklist/blacklist_parameters.json")));
        parser.parseArgument(args);
        String dbUrl = parser.get("postgresUrl");
        String dbUser = parser.get("postgresUser");
        String dbPassword = parser.get("postgresPassword");
        String hdfsPath = parser.get("hdfsPath") + "/blacklist";
        String hdfsNameNode = parser.get("hdfsNameNode");
        try (ReadBlacklistFromDB rbl = new ReadBlacklistFromDB(hdfsPath, hdfsNameNode, dbUrl, dbUser, dbPassword);){
            log.info((Object)"Processing blacklist...");
            rbl.execute(query, rbl::processBlacklistEntry);
        }
    }

    public void execute(String sql, Function<ResultSet, List<Relation>> producer) throws Exception {
        Consumer<ResultSet> consumer = rs -> ((List)producer.apply((ResultSet)rs)).forEach(r -> this.writeRelation((Relation)r));
        this.dbClient.processResults(sql, consumer);
    }

    public List<Relation> processBlacklistEntry(ResultSet rs) {
        try {
            Relation direct = new Relation();
            Relation inverse = new Relation();
            String source_prefix = (String)ModelSupport.entityIdPrefix.get(rs.getString("source_type"));
            String target_prefix = (String)ModelSupport.entityIdPrefix.get(rs.getString("target_type"));
            String source_direct = source_prefix + "|" + rs.getString("source");
            direct.setSource(source_direct);
            inverse.setTarget(source_direct);
            String target_direct = target_prefix + "|" + rs.getString("target");
            direct.setTarget(target_direct);
            inverse.setSource(target_direct);
            String encoding = rs.getString("relationship");
            RelationInverse ri = (RelationInverse)ModelSupport.relationInverseMap.get(encoding);
            direct.setRelClass(ri.getRelation());
            inverse.setRelClass(ri.getInverse());
            direct.setRelType(ri.getRelType());
            inverse.setRelType(ri.getRelType());
            direct.setSubRelType(ri.getSubReltype());
            inverse.setSubRelType(ri.getSubReltype());
            return Arrays.asList(direct, inverse);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.dbClient.close();
        this.writer.close();
    }

    public ReadBlacklistFromDB(String hdfsPath, String hdfsNameNode, String dbUrl, String dbUser, String dbPassword) throws Exception {
        this.dbClient = new DbClient(dbUrl, dbUser, dbPassword);
        this.conf = new Configuration();
        this.conf.set("fs.defaultFS", hdfsNameNode);
        FileSystem fileSystem = FileSystem.get((Configuration)this.conf);
        Path hdfsWritePath = new Path(hdfsPath);
        FSDataOutputStream fsDataOutputStream = null;
        fsDataOutputStream = fileSystem.exists(hdfsWritePath) ? fileSystem.append(hdfsWritePath) : fileSystem.create(hdfsWritePath);
        this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fsDataOutputStream, StandardCharsets.UTF_8));
    }

    protected void writeRelation(Relation r) {
        try {
            this.writer.write(this.OBJECT_MAPPER.writeValueAsString((Object)r));
            this.writer.newLine();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

