/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.inspector;

import com.google.common.collect.Maps;
import eu.dnetlib.miscutils.datetime.DateUtils;
import eu.dnetlib.miscutils.dom4j.XPathHelper;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class TouchUtils {
    private static final Log log = LogFactory.getLog(TouchUtils.class);

    public String updateProfile(String file, String xpath) throws DocumentException {
        SAXReader reader = new SAXReader();
        log.debug((Object)("updating XPath: " + xpath));
        Document document = reader.read((Reader)new StringReader(file));
        Node node = document.selectSingleNode(xpath);
        if (node == null || node.getNodeType() != 1 && node.getNodeType() != 2) {
            throw new DocumentException("Invalid xpath: " + xpath + ": " + node);
        }
        if (this.verifyIsDate(node.getText())) {
            node.setText(DateUtils.now_ISO8601());
        }
        return document.asXML();
    }

    protected boolean verifyIsDate(String text) {
        try {
            new DateUtils().parse(text);
            return true;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    protected String spanize(String file) {
        SAXReader reader = new SAXReader();
        try {
            Document document = reader.read((Reader)new StringReader(file));
            this.traverse(document.getRootElement(), "/*");
            return document.asXML().replace("&apos;", "'");
        }
        catch (DocumentException e) {
            log.warn((Object)e);
            return e.getMessage();
        }
    }

    private void traverse(Element element, String xpathFather) {
        int i = 1;
        for (Element node : XPathHelper.selectElements((Node)element, (String)"./*")) {
            String xpath = xpathFather + "/*[" + i++ + "]";
            HashMap attributeXPaths = Maps.newHashMap();
            List attributes = node.attributes();
            for (Attribute attribute : attributes) {
                attributeXPaths.put(attribute, xpath + "/@" + attribute.getName());
            }
            node.attributes().clear();
            for (Map.Entry entry : attributeXPaths.entrySet()) {
                Attribute attribute = (Attribute)entry.getKey();
                String modifiedName = "_|span id='" + (String)entry.getValue() + "'|_" + attribute.getName() + "_|/span|_";
                node.addAttribute(modifiedName, attribute.getValue());
            }
            if (node.isTextOnly()) {
                node.setName("_|span id='" + xpath + "'|_" + node.getName() + "_|/span|_");
            }
            this.traverse(node, xpath);
        }
    }

    public String escape(String file) {
        return file.replace("_|", "<").replace("|_", ">");
    }
}

