/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.inspector;

import eu.dnetlib.enabling.inspector.AbstractInspectorController;
import eu.dnetlib.enabling.inspector.ResourceLinkTool;
import eu.dnetlib.xml.database.XMLDatabase;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Resource;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.xmldb.api.base.XMLDBException;

@Controller
public class QueryController
extends AbstractInspectorController {
    private static final Log log = LogFactory.getLog(QueryController.class);
    @Resource(name="existDatabase")
    private transient XMLDatabase xmlDatabase;
    @Resource(name="resourcelinkTool")
    private ResourceLinkTool linkTool;

    @RequestMapping(value={"/inspector/query.do"})
    void query(Model model, @RequestParam(value="query", required=false) String query) {
        if (query != null) {
            log.info((Object)("running query: " + query));
            try {
                Iterator it = this.xmlDatabase.xquery(query);
                List res = StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 1024), false).map(StringEscapeUtils::escapeHtml).map(this.linkTool::linkfyToHtml).collect(Collectors.toList());
                model.addAttribute("size", (Object)res.size());
                model.addAttribute("results", res);
            }
            catch (XMLDBException e) {
                model.addAttribute("message", (Object)("failed: " + e.getMessage()));
            }
        }
        model.addAttribute("query", (Object)query);
    }
}

