package eu.dnetlib.enabling.database.resultset;

import java.util.Date;

import org.springframework.beans.factory.annotation.Required;

import eu.dnetlib.enabling.database.utils.DatabaseUtils;
import eu.dnetlib.enabling.resultset.ResultSetListener;

public class SQLResultSetListenerFactory {
	
	private DatabaseUtils dbUtils;

	public ResultSetListener createSQLListener(String db, String sql) {
		return new IterableSQLResultSetListener(db, sql, dbUtils);
	}
	
	public ResultSetListener createSQLListenerWithSize(String db, String sql, String sqlForSize) {
		return new IterableSQLResultSetListener(db, sql, sqlForSize, dbUtils);
	}
		
	public ResultSetListener createTableListener(String db, String table) {
		return new TableDumperResultSetListener(db, table, null, dbUtils);
	}
	
	public ResultSetListener createCondTableListener(String db, String table, String where) {
		return new TableDumperResultSetListener(db, table, where, dbUtils);
	}

	public ResultSetListener createLoggedTableListener(String db, String table, Date from, Date until) {
		return new LoggedTableDumperResultSetListener(db, table, from, until, dbUtils);
	}

	@Required
	public void setDbUtils(DatabaseUtils dbUtils) {
		this.dbUtils = dbUtils;
	}

}
