/*
 * Decompiled with CFR 0.152.
 */
package io.minio;

import io.minio.GenericResponse;
import io.minio.messages.CompleteMultipartUploadResult;
import io.minio.messages.CopyObjectResult;
import okhttp3.Headers;

public class GenericUploadResponse
extends GenericResponse {
    private String etag;
    private String checksumCRC32;
    private String checksumCRC32C;
    private String checksumCRC64NVME;
    private String checksumSHA1;
    private String checksumSHA256;
    private String checksumType;

    public GenericUploadResponse(Headers headers, String bucket, String region, String object, String etag) {
        super(headers, bucket, region, object);
        this.etag = etag;
        if (headers != null) {
            this.checksumCRC32 = headers.get("x-amz-checksum-crc32");
            this.checksumCRC32C = headers.get("x-amz-checksum-crc32c");
            this.checksumCRC64NVME = headers.get("x-amz-checksum-crc64nvme");
            this.checksumSHA1 = headers.get("x-amz-checksum-sha1");
            this.checksumSHA256 = headers.get("x-amz-checksum-sha256");
            this.checksumType = headers.get("x-amz-checksum-type");
        }
    }

    public GenericUploadResponse(Headers headers, String bucket, String region, String object, String etag, CopyObjectResult result) {
        super(headers, bucket, region, object);
        this.etag = etag;
        if (result != null) {
            this.checksumType = result.checksumType();
            this.checksumCRC32 = result.checksumCRC32();
            this.checksumCRC32C = result.checksumCRC32C();
            this.checksumCRC64NVME = result.checksumCRC64NVME();
            this.checksumSHA1 = result.checksumSHA1();
            this.checksumSHA256 = result.checksumSHA256();
        }
    }

    public GenericUploadResponse(Headers headers, String bucket, String region, String object, String etag, CompleteMultipartUploadResult result) {
        super(headers, bucket, region, object);
        this.etag = etag;
        if (result != null) {
            this.checksumType = result.checksumType();
            this.checksumCRC32 = result.checksumCRC32();
            this.checksumCRC32C = result.checksumCRC32C();
            this.checksumCRC64NVME = result.checksumCRC64NVME();
            this.checksumSHA1 = result.checksumSHA1();
            this.checksumSHA256 = result.checksumSHA256();
        }
    }

    public String etag() {
        return this.etag;
    }

    public String checksumCRC32() {
        return this.checksumCRC32;
    }

    public String checksumCRC32C() {
        return this.checksumCRC32C;
    }

    public String checksumCRC64NVME() {
        return this.checksumCRC64NVME;
    }

    public String checksumSHA1() {
        return this.checksumSHA1;
    }

    public String checksumSHA256() {
        return this.checksumSHA256;
    }

    public String checksumType() {
        return this.checksumType;
    }
}

