/*
 * Decompiled with CFR 0.152.
 */
package eu.openaire.openaire_ostrails_api.service;

import eu.dnetlib.validator.api.request.ValidationRequest;
import eu.dnetlib.validator.api.response.ValidationResponse;
import eu.dnetlib.validator2.validation.guideline.openaire.AbstractOpenAireProfile;
import eu.dnetlib.validator2.validation.guideline.openaire.FAIR_Data_GuidelinesProfile;
import eu.dnetlib.validator2.validation.guideline.openaire.FAIR_Literature_GuidelinesV4Profile;
import eu.openaire.openaire_ostrails_api.dto.Benchmark;
import eu.openaire.openaire_ostrails_api.dto.TestResultSet;
import eu.openaire.openaire_ostrails_api.mapper.TestResultSetMapper;
import eu.openaire.openaire_ostrails_api.service.TestService;
import eu.openaire.openaire_ostrails_api.service.ValidatorService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BenchmarkService {
    private static final Logger log = LogManager.getLogger(BenchmarkService.class);
    private final TestResultSetMapper testResultSetMapper = new TestResultSetMapper();
    private FAIR_Literature_GuidelinesV4Profile literatureProfile = new FAIR_Literature_GuidelinesV4Profile();
    private FAIR_Data_GuidelinesProfile dataProfile = new FAIR_Data_GuidelinesProfile();
    @Autowired
    TestService testService;
    @Autowired
    ValidatorService validatorService;
    private Map<String, AbstractOpenAireProfile> benchmarksMap = Map.of("OpenAIRE FAIR Guidelines for Literature Profile", new FAIR_Literature_GuidelinesV4Profile(), "OpenAIRE FAIR Guidelines for Data Repositories Profile", new FAIR_Data_GuidelinesProfile());

    public List<String> listProfileIds() {
        return new ArrayList<String>(this.benchmarksMap.keySet());
    }

    public Benchmark getBenchmark(String benchmarkId) {
        if (benchmarkId.equals("OpenAIRE FAIR Guidelines for Literature Profile") || benchmarkId.equals("OpenAIRE FAIR Guidelines for Data Repositories Profile")) {
            return Benchmark.builder().title(benchmarkId).description(benchmarkId).associatedMetric(((AbstractOpenAireProfile)this.benchmarksMap.get(benchmarkId)).guidelines().stream().map(guideline -> guideline.getFairRuleId()).collect(Collectors.toList())).build();
        }
        return null;
    }

    public TestResultSet validate(String resourceIdentifier, String identifierPrefix) {
        ValidationRequest validationRequest = new ValidationRequest();
        validationRequest.setGuidelines(this.dataProfile.name());
        validationRequest.setBaseUrl(resourceIdentifier);
        validationRequest.setNumberOfRecords(1);
        ValidationResponse validationResponse = this.validatorService.validate(validationRequest);
        return this.testResultSetMapper.toTestResultSet(validationResponse, identifierPrefix);
    }
}

