/*
 * Decompiled with CFR 0.152.
 */
package eu.openaire.openaire_ostrails_api.mapper;

import eu.dnetlib.validator.api.response.ValidationResponse;
import eu.openaire.openaire_ostrails_api.dto.License;
import eu.openaire.openaire_ostrails_api.dto.TestResult;
import eu.openaire.openaire_ostrails_api.dto.TestResultSet;
import eu.openaire.openaire_ostrails_api.mapper.TestResultMapper;
import java.util.List;
import java.util.stream.Collectors;

public class TestResultSetMapper {
    private final TestResultMapper testResultMapper = new TestResultMapper();

    public TestResultSet toTestResultSet(ValidationResponse response, String identifierPrefix) {
        if (response == null || response.getResults() == null || response.getResults().isEmpty()) {
            return null;
        }
        TestResultSet testResultSet = new TestResultSet();
        testResultSet.setTitle("Set of test results for " + ((ValidationResponse.Result)response.getResults().get(0)).getGuidelines() + " Banchmark");
        testResultSet.setDescription("Results from Running " + ((ValidationResponse.Result)response.getResults().get(0)).getGuidelines() + " Banchmark");
        testResultSet.setAssessmentTarget(((ValidationResponse.Result)response.getResults().get(0)).getRecordUrl());
        testResultSet.setLicense(License.builder().id("https://w3id.org/fair/license").build());
        this.enhanceWithTestResult(response, testResultSet, identifierPrefix);
        return testResultSet;
    }

    private void enhanceWithTestResult(ValidationResponse response, TestResultSet testResultSet, String identifierPrefix) {
        for (ValidationResponse.Result validationResult : response.getResults()) {
            List issues = null;
            if (validationResult.getRuleId() != null) {
                issues = response.getIssues().stream().filter(issue -> validationResult.getRuleId().equals(issue.getRuleId())).collect(Collectors.toList());
            }
            TestResult testResult = this.testResultMapper.toTestResult(validationResult, issues);
            testResult.setId(identifierPrefix + "/tests/" + validationResult.getRuleId());
            testResult.setIdentifier(identifierPrefix + "/tests/" + validationResult.getRuleId());
            testResultSet.getHadMember().add(testResult);
        }
    }

    private ValidationResponse buildSingleResponse(ValidationResponse original, ValidationResponse.Result r) {
        ValidationResponse temp = new ValidationResponse();
        temp.setResults(List.of(r));
        temp.setIssues(original.getIssues());
        return temp;
    }

    private String getOverallStatus(ValidationResponse response) {
        boolean hasErrors = response.getResults().stream().anyMatch(ValidationResponse.Result::isHasErrors);
        return hasErrors ? "FAILURE" : "SUCCESS";
    }

    private String buildCombinedLog(ValidationResponse response) {
        if (response.getIssues() == null || response.getIssues().isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (ValidationResponse.Issue issue : response.getIssues()) {
            sb.append("[").append(issue.getIssueType()).append("] ").append(issue.getIssueText()).append("\n");
        }
        return sb.toString().trim();
    }
}

