/*
 * Decompiled with CFR 0.152.
 */
package eu.openaire.openaire_ostrails_api.controller;

import eu.openaire.openaire_ostrails_api.dto.ResourceRequest;
import eu.openaire.openaire_ostrails_api.dto.Test;
import eu.openaire.openaire_ostrails_api.dto.TestResult;
import eu.openaire.openaire_ostrails_api.mapper.RDFMapper;
import eu.openaire.openaire_ostrails_api.service.TestService;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/osTrails/tests"})
@Tag(name="Tests API")
public class TestController {
    @Autowired
    private TestService testService;
    RDFMapper rdfMapper = new RDFMapper();

    @GetMapping(value={"/"})
    public ResponseEntity<List<String>> listTestEndpoints(HttpServletRequest request) {
        return ResponseEntity.ok(this.testService.listGuidelineIds().stream().map(guideline -> request.getRequestURL().toString() + guideline).collect(Collectors.toList()));
    }

    @GetMapping(value={"/{testId}"}, produces={"application/ld+json", "text/turtle"})
    public ResponseEntity<String> getTest(HttpServletRequest request, @PathVariable String testId) {
        Test test = this.testService.getTest(testId);
        if (test == null) {
            return ResponseEntity.notFound().build();
        }
        test.setUri(request.getRequestURL().toString());
        test.setIdentifier(request.getRequestURL().toString());
        String accept = request.getHeader("Accept");
        if (accept != null && accept.contains("text/turtle")) {
            String body = this.rdfMapper.toTurtle(test);
            return ResponseEntity.ok().contentType(MediaType.parseMediaType((String)"text/turtle")).body((Object)body);
        }
        String body = this.rdfMapper.toJsonLd(test);
        return ResponseEntity.ok().contentType(MediaType.parseMediaType((String)"application/ld+json")).body((Object)body);
    }

    @PostMapping(value={"/{testId}"}, produces={"application/ld+json", "text/turtle"})
    public ResponseEntity<String> runTest(HttpServletRequest request, @RequestBody ResourceRequest resource, @PathVariable String testId) {
        TestResult testResult = this.testService.validate(testId, resource.getResourceIdentifier());
        testResult.setId(request.getRequestURL().toString());
        testResult.setIdentifier(request.getRequestURL().toString());
        String accept = request.getHeader("Accept");
        if (accept != null && accept.contains("text/turtle")) {
            String body = this.rdfMapper.toTurtle(testResult);
            return ResponseEntity.ok().contentType(MediaType.parseMediaType((String)"text/turtle")).body((Object)body);
        }
        String body = this.rdfMapper.toJsonLd(testResult);
        return ResponseEntity.ok().contentType(MediaType.parseMediaType((String)"application/ld+json")).body((Object)body);
    }
}

