/*
 * Decompiled with CFR 0.152.
 */
package eu.openaire.openaire_ostrails_api.mapper;

import com.github.jsonldjava.core.JsonLdOptions;
import com.github.jsonldjava.core.JsonLdProcessor;
import com.github.jsonldjava.utils.JsonUtils;
import eu.openaire.openaire_ostrails_api.dto.Advice;
import eu.openaire.openaire_ostrails_api.dto.Benchmark;
import eu.openaire.openaire_ostrails_api.dto.GuidanceElement;
import eu.openaire.openaire_ostrails_api.dto.Metric;
import eu.openaire.openaire_ostrails_api.dto.Test;
import eu.openaire.openaire_ostrails_api.dto.TestResult;
import eu.openaire.openaire_ostrails_api.dto.TestResultSet;
import java.io.StringWriter;
import java.io.Writer;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

/*
 * Exception performing whole class analysis ignored.
 */
public class RDFMapper {
    private static final String DCT = "http://purl.org/dc/terms/";
    private static final String DCAT = "http://www.w3.org/ns/dcat#";
    private static final String FTR = "https://w3id.org/ftr#";
    private static final String PROV = "http://www.w3.org/ns/prov#";
    private static final String XSD = "http://www.w3.org/2001/XMLSchema#";
    private static final String DQV = "http://www.w3.org/ns/dqv";
    private static final String SIO = "http://semanticscience.org/resource/";
    private static final String CMVO = "https://w3id.org/cmvo/";
    private static final String GUIDANCE_NS = "https://example.org/guidance/type/";

    private static void addTestRDFPrefixes(Model model) {
        model.setNsPrefix("dcterms", "http://purl.org/dc/terms/");
        model.setNsPrefix("dcat", "http://www.w3.org/ns/dcat#");
        model.setNsPrefix("ftr", "https://w3id.org/ftr#");
        model.setNsPrefix("prov", "http://www.w3.org/ns/prov#");
        model.setNsPrefix("xsd", "http://www.w3.org/2001/XMLSchema#");
        model.setNsPrefix("dqr", "http://www.w3.org/ns/dqv");
    }

    private static void addMetricRDFPrefixes(Model model) {
        model.setNsPrefix("dcterms", "http://purl.org/dc/terms/");
        model.setNsPrefix("dcat", "http://www.w3.org/ns/dcat#");
        model.setNsPrefix("ftr", "https://w3id.org/ftr#");
        model.setNsPrefix("prov", "http://www.w3.org/ns/prov#");
        model.setNsPrefix("xsd", "http://www.w3.org/2001/XMLSchema#");
        model.setNsPrefix("dqr", "http://www.w3.org/ns/dqv");
    }

    private static void addBenchmarkRDFPrefixes(Model model) {
        model.setNsPrefix("dcterms", "http://purl.org/dc/terms/");
        model.setNsPrefix("dcat", "http://www.w3.org/ns/dcat#");
        model.setNsPrefix("ftr", "https://w3id.org/ftr#");
        model.setNsPrefix("prov", "http://www.w3.org/ns/prov#");
        model.setNsPrefix("xsd", "http://www.w3.org/2001/XMLSchema#");
        model.setNsPrefix("dqr", "http://www.w3.org/ns/dqv");
    }

    private static void addTestResultRDFPrefixes(Model model) {
        model.setNsPrefix("dcterms", "http://purl.org/dc/terms/");
        model.setNsPrefix("dcat", "http://www.w3.org/ns/dcat#");
        model.setNsPrefix("ftr", "https://w3id.org/ftr#");
        model.setNsPrefix("prov", "http://www.w3.org/ns/prov#");
        model.setNsPrefix("xsd", "http://www.w3.org/2001/XMLSchema#");
        model.setNsPrefix("dqr", "http://www.w3.org/ns/dqv");
        model.setNsPrefix("sio", "http://semanticscience.org/resource/");
        model.setNsPrefix("cmvo", "https://w3id.org/cmvo/");
        model.setNsPrefix("guidance", "https://example.org/guidance/type/");
        model.setNsPrefix("rdfs", RDFS.getURI());
        model.setNsPrefix("owl", OWL.getURI());
    }

    private static void addTestResultSetRDFPrefixes(Model model) {
        model.setNsPrefix("dcterms", "http://purl.org/dc/terms/");
        model.setNsPrefix("dcat", "http://www.w3.org/ns/dcat#");
        model.setNsPrefix("ftr", "https://w3id.org/ftr#");
        model.setNsPrefix("prov", "http://www.w3.org/ns/prov#");
        model.setNsPrefix("xsd", "http://www.w3.org/2001/XMLSchema#");
        model.setNsPrefix("dqr", "http://www.w3.org/ns/dqv");
        model.setNsPrefix("sio", "http://semanticscience.org/resource/");
        model.setNsPrefix("cmvo", "https://w3id.org/cmvo/");
        model.setNsPrefix("guidance", "https://example.org/guidance/type/");
    }

    public String toJsonLd(Test test) {
        Model model = this.toModel(test);
        return this.modelToString(model, "JSON-LD");
    }

    public String toTurtle(Test test) {
        Model model = this.toModel(test);
        return this.modelToString(model, "TURTLE");
    }

    public String toJsonLd(Metric metric) {
        Model model = this.toModel(metric);
        return this.modelToString(model, "JSON-LD");
    }

    public String toTurtle(Metric metric) {
        Model model = this.toModel(metric);
        return this.modelToString(model, "TURTLE");
    }

    public String toJsonLd(Benchmark benchmark) {
        Model model = this.toModel(benchmark);
        return this.modelToString(model, "JSON-LD");
    }

    public String toTurtle(Benchmark benchmark) {
        Model model = this.toModel(benchmark);
        return this.modelToString(model, "TURTLE");
    }

    public String toJsonLd(TestResult testResult) {
        System.out.println("HERE TO JSONLD");
        Model model = this.toModel(testResult);
        return this.modelToString(model, "JSON-LD");
    }

    public String toTurtle(TestResult testResult) {
        Model model = this.toModel(testResult);
        return this.modelToString(model, "TURTLE");
    }

    public String toJsonLd(TestResultSet testResultSet) {
        Model model = this.toModel(testResultSet);
        String TEST_RESULT_SET_FRAME = "{\n  \"@context\": {\n    \"xsd\": \"http://www.w3.org/2001/XMLSchema#\",\n    \"dcterms\": \"http://purl.org/dc/terms/\",\n    \"dcat\": \"http://www.w3.org/ns/dcat#\",\n    \"ftr\": \"https://w3id.org/ftr#\",\n    \"prov\": \"http://www.w3.org/ns/prov#\"\n  },\n  \"@type\": \"ftr:TestResultSet\",\n  \"prov:hadMember\": { \"@embed\": \"@always\" }\n}\n";
        return this.frameJsonLdManually(model, "{\n  \"@context\": {\n    \"xsd\": \"http://www.w3.org/2001/XMLSchema#\",\n    \"dcterms\": \"http://purl.org/dc/terms/\",\n    \"dcat\": \"http://www.w3.org/ns/dcat#\",\n    \"ftr\": \"https://w3id.org/ftr#\",\n    \"prov\": \"http://www.w3.org/ns/prov#\"\n  },\n  \"@type\": \"ftr:TestResultSet\",\n  \"prov:hadMember\": { \"@embed\": \"@always\" }\n}\n");
    }

    private String frameJsonLdManually(Model model, String frameJson) {
        try {
            StringWriter tmp = new StringWriter();
            RDFDataMgr.write((StringWriter)tmp, (Model)model, (Lang)Lang.JSONLD);
            Object jsonObject = JsonUtils.fromString((String)tmp.toString());
            Object frameObject = JsonUtils.fromString((String)frameJson);
            Map framed = JsonLdProcessor.frame((Object)jsonObject, (Object)frameObject, (JsonLdOptions)new JsonLdOptions());
            return JsonUtils.toPrettyString((Object)framed);
        }
        catch (Exception e) {
            throw new RuntimeException("Error applying JSON-LD frame", e);
        }
    }

    public String toTurtle(TestResultSet testResultSet) {
        Model model = this.toModel(testResultSet);
        return this.modelToString(model, "TURTLE");
    }

    private String modelToString(Model model, String format) {
        String string;
        StringWriter writer = new StringWriter();
        try {
            model.write((Writer)writer, format);
            string = writer.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    writer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException("Error converting RDF model to string", e);
            }
        }
        writer.close();
        return string;
    }

    private Model toModel(Test test) {
        Model model = ModelFactory.createDefaultModel();
        RDFMapper.addTestRDFPrefixes((Model)model);
        Resource testResource = model.createResource(test.getIdentifier()).addProperty(RDF.type, (RDFNode)model.createResource("https://w3id.org/ftr#Test")).addProperty(model.createProperty("http://purl.org/dc/terms/", "title"), test.getTitle()).addProperty(model.createProperty("http://purl.org/dc/terms/", "identifier"), test.getIdentifier()).addProperty(model.createProperty("http://www.w3.org/ns/dqv", "isApplicableFor"), (RDFNode)model.createResource(test.getIsApplicableFor()));
        if (test.getDescription() != null) {
            testResource.addProperty(model.createProperty("http://purl.org/dc/terms/", "description"), test.getDescription());
        }
        if (test.getLicense() != null) {
            testResource.addProperty(model.createProperty("http://purl.org/dc/terms/", "license"), (RDFNode)model.createResource(test.getLicense()));
        }
        if (test.getCreator() != null && !test.getCreator().isEmpty()) {
            Property creator = model.createProperty("http://purl.org/dc/terms/", "creator");
            for (String orcid : test.getCreator()) {
                testResource.addProperty(creator, (RDFNode)model.createResource(orcid));
            }
        }
        if (test.getEndpointURL() != null) {
            testResource.addProperty(model.createProperty("http://www.w3.org/ns/dcat#", "endpointURL"), (RDFNode)model.createResource(test.getEndpointURL()));
        }
        return model;
    }

    private Model toModel(Metric metric) {
        Model model = ModelFactory.createDefaultModel();
        RDFMapper.addMetricRDFPrefixes((Model)model);
        Resource metricResource = model.createResource(metric.getIdentifier()).addProperty(RDF.type, (RDFNode)model.createResource("https://w3id.org/ftr#Metric")).addProperty(model.createProperty("http://purl.org/dc/terms/", "title"), metric.getTitle()).addProperty(model.createProperty("http://purl.org/dc/terms/", "description"), metric.getDescription()).addProperty(model.createProperty("http://purl.org/dc/terms/", "identifier"), metric.getIdentifier()).addProperty(model.createProperty("http://www.w3.org/ns/dqv", "isApplicableFor"), (RDFNode)model.createResource(metric.getIsApplicableFor()));
        if (metric.getLicense() != null) {
            metricResource.addProperty(model.createProperty("http://purl.org/dc/terms/", "license"), (RDFNode)model.createResource(metric.getLicense()));
        }
        if (metric.getEndpointURL() != null) {
            metricResource.addProperty(model.createProperty("http://www.w3.org/ns/dcat#", "endpointURL"), (RDFNode)model.createResource(metric.getEndpointURL()));
        }
        if (metric.getTest() != null) {
            for (String test : metric.getTest()) {
                metricResource.addProperty(model.createProperty("https://w3id.org/ftr#", "hasTest"), (RDFNode)model.createResource(test));
            }
        }
        if (metric.getFairPrinciple() != null) {
            metricResource.addProperty(model.createProperty("http://www.w3.org/ns/dqv", "inDimension"), (RDFNode)model.createResource("https://w3id.org/fair/principles/terms/" + metric.getFairPrinciple()));
        }
        if (metric.getTest() != null) {
            for (String test : metric.getTest()) {
                metricResource.addProperty(model.createProperty("https://w3id.org/ftr#", "hasImplementation"), (RDFNode)model.createResource(test));
            }
        }
        if (metric.getLicense() != null) {
            metricResource.addProperty(model.createProperty("http://purl.org/dc/terms/", "license"), (RDFNode)model.createResource(metric.getLicense()));
        }
        if (metric.getCreator() != null && !metric.getCreator().isEmpty()) {
            Property creator = model.createProperty("http://purl.org/dc/terms/", "creator");
            for (String orcid : metric.getCreator()) {
                metricResource.addProperty(creator, (RDFNode)model.createResource(orcid));
            }
        }
        return model;
    }

    private Model toModel(Benchmark benchmark) {
        Model model = ModelFactory.createDefaultModel();
        RDFMapper.addBenchmarkRDFPrefixes((Model)model);
        Resource benchmarkResource = model.createResource(benchmark.getIdentifier()).addProperty(RDF.type, (RDFNode)model.createResource("https://w3id.org/ftr#Benchmark")).addProperty(model.createProperty("http://purl.org/dc/terms/", "title"), benchmark.getTitle()).addProperty(model.createProperty("http://purl.org/dc/terms/", "identifier"), benchmark.getIdentifier());
        if (benchmark.getDescription() != null) {
            benchmarkResource.addProperty(model.createProperty("http://purl.org/dc/terms/", "description"), benchmark.getDescription());
        }
        if (benchmark.getLicense() != null) {
            benchmarkResource.addProperty(model.createProperty("http://purl.org/dc/terms/", "license"), (RDFNode)model.createResource(benchmark.getLicense()));
        }
        if (benchmark.getCreator() != null && !benchmark.getCreator().isEmpty()) {
            Property creator = model.createProperty("http://purl.org/dc/terms/", "creator");
            for (String orcid : benchmark.getCreator()) {
                benchmarkResource.addProperty(creator, (RDFNode)model.createResource(orcid));
            }
        }
        for (String metric : benchmark.getAssociatedMetric()) {
            benchmarkResource.addProperty(model.createProperty("https://w3id.org/ftr#associatedMetric"), metric);
        }
        return model;
    }

    private Model toModel(TestResult testResult) {
        Model model = ModelFactory.createDefaultModel();
        RDFMapper.addTestResultRDFPrefixes((Model)model);
        String dummyBase = testResult.getIdentifier().substring(0, testResult.getIdentifier().lastIndexOf("/tests")) + "/";
        model.setNsPrefix("", dummyBase);
        Resource testResource = model.createResource(testResult.getIdentifier()).addProperty(RDF.type, (RDFNode)model.createResource("https://w3id.org/ftr#TestResult")).addProperty(model.createProperty("http://purl.org/dc/terms/", "title"), testResult.getTitle()).addProperty(model.createProperty("http://purl.org/dc/terms/", "identifier"), testResult.getIdentifier());
        if (testResult.getDescription() != null) {
            testResource.addProperty(model.createProperty("http://purl.org/dc/terms/", "description"), testResult.getDescription());
        }
        if (testResult.getLicense() != null) {
            testResource.addProperty(model.createProperty("http://purl.org/dc/terms/", "license"), (RDFNode)model.createResource(testResult.getLicense().getId()));
        }
        String now = LocalDateTime.now().format(DateTimeFormatter.ISO_DATE_TIME);
        testResource.addLiteral(model.createProperty("http://www.w3.org/ns/prov#", "generatedAtTime"), model.createTypedLiteral(now, "http://www.w3.org/2001/XMLSchema#dateTime"));
        testResource.addProperty(model.createProperty("http://www.w3.org/ns/prov#", "value"), testResult.getValue());
        testResource.addLiteral(model.createProperty("https://w3id.org/ftr#", "completion"), (long)testResult.getCompletion());
        testResource.addProperty(model.createProperty("https://w3id.org/ftr#", "log"), testResult.getLog() != null ? testResult.getLog() : "No log");
        Resource testDef = model.createResource(testResult.getId()).addProperty(RDF.type, (RDFNode)model.createResource("https://w3id.org/ftr#Test")).addProperty(model.createProperty("http://purl.org/dc/terms/", "title"), testResult.getTitle()).addProperty(model.createProperty("http://purl.org/dc/terms/", "identifier"), testResult.getId());
        if (testResult.getDescription() != null) {
            testDef.addProperty(model.createProperty("http://purl.org/dc/terms/", "description"), testResult.getDescription());
        }
        if (testResult.getEndpointURL() != null) {
            testDef.addProperty(model.createProperty("http://www.w3.org/ns/dcat#", "endpointURL"), (RDFNode)model.createResource(testResult.getEndpointURL()));
        }
        testResource.addProperty(model.createProperty("https://w3id.org/ftr#", "outputFromTest"), (RDFNode)testDef);
        RDFMapper.createSuggestions((TestResult)testResult, (Model)model, (String)dummyBase, (Resource)testResource);
        return model;
    }

    private static void createSuggestions(TestResult testResult, Model model, String dummyBase, Resource testResource) {
        Property ftrSuggestion = model.createProperty("https://w3id.org/ftr#", "suggestion");
        Property sioIsSpecifiedBy = model.createProperty("http://semanticscience.org/resource/", "is-specified-by");
        Property rdfsLabel = model.createProperty(RDFS.getURI(), "label");
        if (testResult.getSuggestions() != null && !testResult.getSuggestions().isEmpty()) {
            for (Advice advice : testResult.getSuggestions()) {
                GuidanceElement ge;
                Resource adviceRes = advice.getId() != null && !advice.getId().isBlank() ? model.createResource(dummyBase + advice.getId()) : model.createResource();
                adviceRes.addProperty(RDF.type, (RDFNode)model.createResource("https://w3id.org/cmvo/Advice"));
                if (advice.getLabel() != null) {
                    adviceRes.addProperty(rdfsLabel, advice.getLabel());
                }
                if (advice.getDescription() != null) {
                    adviceRes.addProperty(model.createProperty("http://purl.org/dc/terms/", "description"), advice.getDescription());
                }
                testResource.addProperty(ftrSuggestion, (RDFNode)adviceRes);
                if (advice.getRelatedResources() != null) {
                    for (String link : advice.getRelatedResources()) {
                        if (link == null || link.isBlank()) continue;
                        adviceRes.addProperty(model.createProperty("http://purl.org/dc/terms/", "relation"), (RDFNode)model.createResource(link));
                    }
                }
                if ((ge = advice.getSpecifiedBy()) == null) continue;
                Resource guidanceRes = ge.getId() != null && !ge.getId().isBlank() ? model.createResource(dummyBase + ge.getId()) : model.createResource();
                guidanceRes.addProperty(RDF.type, (RDFNode)model.createResource("http://semanticscience.org/resource/Specification"));
                if (ge.getType() != null) {
                    guidanceRes.addProperty(RDF.type, (RDFNode)model.createResource("https://example.org/guidance/type/" + ge.getType().name()));
                }
                if (ge.getTitle() != null) {
                    guidanceRes.addProperty(model.createProperty("http://purl.org/dc/terms/", "title"), ge.getTitle());
                }
                if (ge.getDescription() != null) {
                    guidanceRes.addProperty(model.createProperty("http://purl.org/dc/terms/", "description"), ge.getDescription());
                }
                if (ge.getVersion() != null) {
                    guidanceRes.addProperty(model.createProperty(OWL.getURI(), "versionInfo"), ge.getVersion());
                }
                if (ge.getCreatedBy() != null) {
                    guidanceRes.addProperty(model.createProperty("http://purl.org/dc/terms/", "creator"), ge.getCreatedBy());
                }
                if (ge.getCreatedDate() != null) {
                    guidanceRes.addProperty(model.createProperty("http://purl.org/dc/terms/", "created"), ge.getCreatedDate());
                }
                if (ge.getRelatedResources() != null) {
                    for (String link : ge.getRelatedResources()) {
                        if (link == null || link.isBlank()) continue;
                        guidanceRes.addProperty(model.createProperty("http://purl.org/dc/terms/", "relation"), (RDFNode)model.createResource(link));
                    }
                }
                adviceRes.addProperty(sioIsSpecifiedBy, (RDFNode)guidanceRes);
            }
        }
    }

    private Model toModel(TestResultSet testResultSet) {
        Model model = ModelFactory.createDefaultModel();
        model.setNsPrefix("dcterms", "http://purl.org/dc/terms/");
        model.setNsPrefix("dcat", "http://www.w3.org/ns/dcat#");
        model.setNsPrefix("ftr", "https://w3id.org/ftr#");
        model.setNsPrefix("prov", "http://www.w3.org/ns/prov#");
        model.setNsPrefix("xsd", "http://www.w3.org/2001/XMLSchema#");
        String now = LocalDateTime.now().format(DateTimeFormatter.ISO_DATE_TIME);
        Resource testResultSetResource = model.createResource(testResultSet.getIdentifier()).addProperty(RDF.type, (RDFNode)model.createResource("https://w3id.org/ftr#TestResultSet")).addProperty(model.createProperty("http://purl.org/dc/terms/", "identifier"), testResultSet.getIdentifier());
        for (TestResult testResult : testResultSet.getHadMember()) {
            if (testResult.getId() != null) {
                Resource testResultRes = model.createResource(testResult.getIdentifier()).addProperty(RDF.type, (RDFNode)model.createResource("https://w3id.org/ftr#TestResult")).addProperty(model.createProperty("http://purl.org/dc/terms/", "identifier"), testResult.getIdentifier());
                if (testResult.getTitle() != null) {
                    testResultRes.addProperty(model.createProperty("http://purl.org/dc/terms/", "title"), testResult.getTitle());
                }
                if (testResult.getDescription() != null) {
                    testResultRes.addProperty(model.createProperty("http://purl.org/dc/terms/", "description"), testResult.getDescription());
                }
                testResultRes.addLiteral(model.createProperty("http://www.w3.org/ns/prov#", "generatedAtTime"), model.createTypedLiteral(now, "http://www.w3.org/2001/XMLSchema#dateTime"));
                if (testResult.getValue() != null) {
                    testResultRes.addProperty(model.createProperty("http://www.w3.org/ns/prov#", "value"), testResult.getValue());
                }
                testResultRes.addLiteral(model.createProperty("https://w3id.org/ftr#", "completion"), (long)testResult.getCompletion());
                testResultRes.addProperty(model.createProperty("https://w3id.org/ftr#", "log"), testResult.getLog() != null ? testResult.getLog() : "No log");
                Resource testDef = model.createResource(testResult.getId()).addProperty(RDF.type, (RDFNode)model.createResource("https://w3id.org/ftr#Test")).addProperty(model.createProperty("http://purl.org/dc/terms/", "identifier"), testResult.getId());
                testResultRes.addProperty(model.createProperty("https://w3id.org/ftr#", "outputFromTest"), (RDFNode)testDef);
                testResultSetResource.addProperty(model.createProperty("http://www.w3.org/ns/prov#", "hadMember"), (RDFNode)testResultRes);
            }
            String dummyBase = testResult.getIdentifier().substring(0, testResult.getIdentifier().lastIndexOf("/tests")) + "/";
            RDFMapper.createSuggestions((TestResult)testResult, (Model)model, (String)dummyBase, (Resource)testResultSetResource);
        }
        return model;
    }
}

