/*
 * Decompiled with CFR 0.152.
 */
package eu.openaire.openaire_ostrails_api.helper;

import eu.openaire.openaire_ostrails_api.dto.Test;
import eu.openaire.openaire_ostrails_api.dto.TestResult;
import jakarta.servlet.http.HttpServletRequest;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.vocabulary.RDF;

/*
 * Exception performing whole class analysis ignored.
 */
public class DCATFormatter {
    public static Model buildDcatModel(Test test) {
        Model model = DCATFormatter.createBaseModel();
        String base = "https://example.org/tests/";
        Resource testResource = model.createResource(base + test.getIdentifier()).addProperty(RDF.type, (RDFNode)model.createResource("http://www.w3.org/ns/dcat#DataService")).addProperty(model.createProperty("http://purl.org/dc/terms/title"), test.getTitle()).addProperty(model.createProperty("http://purl.org/dc/terms/description"), test.getDescription());
        if (test.getEndpointURL() != null) {
            testResource.addProperty(model.createProperty("http://www.w3.org/ns/dcat#endpointURL"), (RDFNode)model.createResource(test.getEndpointURL()));
        }
        if (test.getLicense() != null) {
            testResource.addProperty(model.createProperty("http://purl.org/dc/terms/license"), (RDFNode)model.createResource(test.getLicense()));
        }
        return model;
    }

    private static Model createBaseModel() {
        Model model = ModelFactory.createDefaultModel();
        model.setNsPrefix("dcat", "http://www.w3.org/ns/dcat#");
        model.setNsPrefix("dc", "http://purl.org/dc/elements/1.1");
        return model;
    }

    public static Model buildDcatModel(TestResult testResult) {
        Model model = DCATFormatter.createBaseModel();
        return model;
    }

    public static RDFFormat resolveFormat(HttpServletRequest request) {
        String contentType = request.getHeader("Accept");
        if (contentType != null && contentType.contains("text/turtle")) {
            return RDFFormat.TURTLE_PRETTY;
        }
        return RDFFormat.JSONLD_PRETTY;
    }
}

