/*
 * Decompiled with CFR 0.152.
 */
package eu.openaire.openaire_ostrails_api.controller;

import eu.openaire.openaire_ostrails_api.dto.Metric;
import eu.openaire.openaire_ostrails_api.mapper.RDFMapper;
import eu.openaire.openaire_ostrails_api.service.MetricService;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/osTrails/metrics"})
@Tag(name="Metrics API")
public class MetricController {
    private final Logger log = LogManager.getLogger(this.getClass());
    @Autowired
    MetricService metricService;
    RDFMapper rdfMapper = new RDFMapper();

    @GetMapping(value={"/"})
    public ResponseEntity<List<String>> listMetricEndpoints(HttpServletRequest request) {
        return ResponseEntity.ok(this.metricService.listGuidelineIds().stream().map(guideline -> request.getRequestURL().toString() + guideline).collect(Collectors.toList()));
    }

    @GetMapping(value={"/{metricId}"}, produces={"application/ld+json", "text/turtle"})
    public ResponseEntity<String> getMetric(@PathVariable String metricId, HttpServletRequest request) {
        Metric metric = this.metricService.getMetric(metricId);
        if (metric == null) {
            return ResponseEntity.notFound().build();
        }
        metric.setUri(request.getRequestURL().toString());
        metric.setIdentifier(request.getRequestURL().toString());
        System.out.println(metric.getTest());
        metric.setTest(Arrays.asList(request.getRequestURL().toString().replace("metrics", "tests")));
        String accept = request.getHeader("Accept");
        if (accept != null && accept.contains("text/turtle")) {
            String body = this.rdfMapper.toTurtle(metric);
            return ResponseEntity.ok().contentType(MediaType.parseMediaType((String)"text/turtle")).body((Object)body);
        }
        String body = this.rdfMapper.toJsonLd(metric);
        return ResponseEntity.ok().contentType(MediaType.parseMediaType((String)"application/ld+json")).body((Object)body);
    }
}

