/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validatorapi.service;

import eu.dnetlib.validator.api.response.IssueDescriptorDto;
import eu.dnetlib.validatorapi.entities.IssueRecordTuple;
import eu.dnetlib.validatorapi.mapper.IssueDescriptorDtoMapper;
import eu.dnetlib.validatorapi.repositories.ValidationIssueRepository;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ValidationIssueService {
    @Autowired
    ValidationIssueRepository validationIssueRepository;
    @Autowired
    IssueDescriptorDtoMapper issueDescriptorDtoMapper;

    public List<IssueDescriptorDto> getAllWarningsRecordUrlsByRuleName(int jobId, String ruleName) {
        List tuples = this.validationIssueRepository.getAllWarningsRecordUrlsByRuleName(jobId, ruleName).stream().map(r -> new IssueRecordTuple((String)r[0], (String)r[1], (String)r[2])).collect(Collectors.toList());
        return this.issueDescriptorDtoMapper.groupToDescriptors(tuples);
    }

    public List<IssueDescriptorDto> getAllErrorsRecordUrlsByRuleName(int jobId, String ruleName) {
        List tuples = this.validationIssueRepository.getAllErrorsRecordUrlsByRuleName(jobId, ruleName).stream().map(r -> new IssueRecordTuple((String)r[0], (String)r[1], (String)r[2])).collect(Collectors.toList());
        return this.issueDescriptorDtoMapper.groupToDescriptors(tuples);
    }
}

