/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validatorapi.routes;

import eu.dnetlib.validatorapi.entities.ValidationIssue;
import eu.dnetlib.validatorapi.entities.ValidationJob;
import eu.dnetlib.validatorapi.entities.ValidationRuleResult;
import eu.dnetlib.validatorapi.processors.DBFinalizingProcessor;
import eu.dnetlib.validatorapi.processors.ExceptionProcessor;
import eu.dnetlib.validatorapi.processors.XmlProcessor;
import java.net.UnknownHostException;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.TypeConversionException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.ThreadsDefinition;
import org.apache.http.client.ClientProtocolException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SedaOaiPmhRoute
extends RouteBuilder {
    @Autowired
    XmlProcessor xmlProcessor;
    @Autowired
    DBFinalizingProcessor DBFinalizingProcessor;
    @Autowired
    ExceptionProcessor exceptionProcessor;

    public void configure() throws Exception {
        ((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)this.onException(TypeConversionException.class).process((Processor)this.exceptionProcessor)).to("jpa:" + ValidationJob.class.getName() + "?useExecuteUpdate=true")).log("TypeConversionException occurred. Skipping DB update for ValidationJob.")).maximumRedeliveries(0).handled(true).end();
        ((OnExceptionDefinition)((OnExceptionDefinition)((OnExceptionDefinition)this.onException(ClientProtocolException.class).process((Processor)this.exceptionProcessor)).to("jpa:" + ValidationJob.class.getName() + "?useExecuteUpdate=true")).log("ClientProtocolException occurred. Skipping DB update for ValidationJob.")).maximumRedeliveries(0).handled(true).end();
        ((OnExceptionDefinition)((OnExceptionDefinition)this.onException(UnknownHostException.class).process((Processor)this.exceptionProcessor)).to("jpa:" + ValidationJob.class.getName() + "?useExecuteUpdate=true")).maximumRedeliveries(0).handled(true).end();
        ((OnExceptionDefinition)((OnExceptionDefinition)this.onException(RuntimeException.class).process((Processor)this.exceptionProcessor)).to("jpa:" + ValidationJob.class.getName() + "?useExecuteUpdate=true")).maximumRedeliveries(0).handled(true).end();
        ((OnExceptionDefinition)((OnExceptionDefinition)this.onException(IllegalArgumentException.class).handled(true).log("Early stop triggered after SPLIT_INDEX > numberOfRecords")).process((Processor)this.DBFinalizingProcessor)).end();
        ((ChoiceDefinition)((ExpressionNode)((ExpressionNode)((ExpressionNode)((ChoiceDefinition)((ChoiceDefinition)((ThreadsDefinition)this.from("seda:oaipmh").threads(10).toD("${header.oaiEndpoint}")).choice().when().xpath("count(//*[local-name()='record']) = 0")).process(exchange -> {
            String responseBody = (String)exchange.getIn().getBody(String.class);
            String message = "No <record> elements found in OAI-PMH response. Response was: " + responseBody;
            throw new RuntimeException(message);
        })).end().split((Expression)this.xpath("//*[local-name()='record']")).streaming().stopOnException().process((Processor)this.xmlProcessor)).split((Expression)this.simple("${body[issues]}")).to("jpa:" + ValidationIssue.class.getName() + "?usePersist=true")).end().split((Expression)this.simple("${body[results]}")).to("jpa:" + ValidationRuleResult.class.getName() + "?usePersist=true")).end().choice().when(this.exchangeProperty("CamelSplitIndex").isEqualTo((Object)this.simple("${header.adjustedNumberOfRecords}"))).throwException((Exception)new IllegalArgumentException("SplitIndex must be less than 10"))).endChoice().end().end().process((Processor)this.DBFinalizingProcessor);
    }
}

