/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validatorapi.processors;

import eu.dnetlib.validator.domain.Progress;
import eu.dnetlib.validator2.validation.guideline.openaire.AbstractOpenAireProfile;
import eu.dnetlib.validatorapi.entities.SummaryResult;
import eu.dnetlib.validatorapi.entities.ValidationJob;
import eu.dnetlib.validatorapi.repositories.SummaryValidationJobRepository;
import eu.dnetlib.validatorapi.repositories.ValidationJobRepository;
import eu.dnetlib.validatorapi.repositories.ValidationResultRepository;
import java.util.Date;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DBFinalizingProcessor
implements Processor {
    private static final Logger log = LoggerFactory.getLogger(DBFinalizingProcessor.class);
    @Autowired
    private ValidationJobRepository validationJobRepository;
    @Autowired
    private ValidationResultRepository validationResultRepository;
    @Autowired
    private SummaryValidationJobRepository summaryValidationJobRepository;

    public void process(Exchange exchange) throws Exception {
        ValidationJob validationJob = (ValidationJob)exchange.getIn().getHeader("ValidationJob");
        AbstractOpenAireProfile profile = (AbstractOpenAireProfile)exchange.getIn().getHeader("Profile");
        Boolean isFair = (Boolean)exchange.getIn().getHeader("isFair");
        if (Boolean.TRUE.equals(isFair)) {
            validationJob.isFairComplete = true;
        } else {
            validationJob.isBasicComplete = true;
        }
        if (validationJob.isFairComplete.booleanValue() && validationJob.isBasicComplete.booleanValue() || !validationJob.hasFair.booleanValue() && validationJob.isBasicComplete.booleanValue()) {
            validationJob.progress = Progress.COMPLETED;
        }
        validationJob.endDate = new Date();
        System.out.println("Validation Job completed: " + validationJob.id + ", " + String.valueOf(validationJob.progress) + " with records processed " + validationJob.recordsTested + "passed records " + validationJob.numberOfRecords);
        System.out.println("Validation Job completed: " + validationJob.guidelines);
        List summaryResults = this.validationResultRepository.getFullSummaryResult(validationJob.id, profile.name());
        for (SummaryResult sr : summaryResults) {
            sr.validationJobId = validationJob.id;
            this.summaryValidationJobRepository.save((Object)sr);
        }
        this.validationJobRepository.save((Object)validationJob);
    }
}

