/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validatorapi.mapper;

import eu.dnetlib.validator.api.response.IssueDescriptorDto;
import eu.dnetlib.validatorapi.entities.IssueRecordTuple;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.mapstruct.Mapper;

@Mapper(componentModel="spring")
public interface IssueDescriptorDtoMapper {
    default public List<IssueDescriptorDto> groupToDescriptors(List<IssueRecordTuple> tuples) {
        LinkedHashMap<String, IssueDescriptorDto> grouped = new LinkedHashMap<String, IssueDescriptorDto>();
        for (IssueRecordTuple tuple : tuples) {
            IssueDescriptorDto dto = grouped.computeIfAbsent(tuple.getIssueText(), key -> {
                IssueDescriptorDto newDto = new IssueDescriptorDto();
                newDto.setDescription(key);
                newDto.setSuggestion(tuple.getSuggestion());
                newDto.setRecords(new ArrayList());
                return newDto;
            });
            dto.getRecords().add(tuple.getRecordUrl());
        }
        return new ArrayList<IssueDescriptorDto>(grouped.values());
    }
}

