/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validatorapi.entities;

import eu.dnetlib.validator.domain.Progress;
import eu.dnetlib.validator.domain.Status;
import java.util.Arrays;
import java.util.Date;
import java.util.Optional;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(name="validation_jobs")
public class ValidationJob {
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Id
    public int id;
    @Column(name="base_url")
    public String baseUrl;
    @Column(name="set")
    public String set;
    @Column(name="number_of_records")
    public int numberOfRecords;
    @Column(name="guidelines")
    public String guidelines;
    @Column(name="started")
    public Date startDate = new Date();
    @Column(name="ended")
    public Date endDate;
    @Column(name="records_tested")
    public int recordsTested;
    @Column(name="has_fair")
    public Boolean hasFair;
    @Column(name="is_basic_complete")
    public Boolean isBasicComplete;
    @Column(name="is_fair_complete")
    public Boolean isFairComplete;
    @Enumerated(value=EnumType.STRING)
    @Column(name="progress")
    public Progress progress;
    @Enumerated(value=EnumType.STRING)
    @Column(name="status")
    public Status status;
    @Column(name="score")
    public double score;
    @Column(name="exception_class")
    public String exceptionClass;
    @Column(name="exception_message")
    public String exceptionMessage;
    @Column(name="ruleIds", columnDefinition="text[]")
    @Type(type="string-array")
    public String[] ruleIds;

    public ValidationJob() {
    }

    public ValidationJob(String baseUrl, Optional<String> set, int numberOfRecords) {
        this.baseUrl = baseUrl;
        if (set != null && set.isPresent()) {
            this.set = set.get();
        }
        this.numberOfRecords = numberOfRecords;
        this.progress = Progress.IN_PROGRESS;
    }

    public String toString() {
        return "ValidationJob{id=" + this.id + ", baseUrl='" + this.baseUrl + "', set='" + this.set + "', numberOfRecords=" + this.numberOfRecords + ", guidelines='" + this.guidelines + "', startDate=" + String.valueOf(this.startDate) + ", endDate=" + String.valueOf(this.endDate) + ", recordsTested=" + this.recordsTested + ", progress=" + String.valueOf(this.progress) + ", status=" + String.valueOf(this.status) + ", score=" + this.score + ", exceptionClass='" + this.exceptionClass + "', exceptionMessage='" + this.exceptionMessage + "', ruleIds=" + Arrays.toString(this.ruleIds) + "}";
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }
}

