/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validatorapi.controllers;

import eu.dnetlib.validator2.result_models.StandardResult;
import eu.dnetlib.validator2.result_models.StandardValidationResult;
import eu.dnetlib.validator2.result_models.ValidationProblem;
import eu.dnetlib.validator2.validation.guideline.openaire.AbstractOpenAireProfile;
import eu.dnetlib.validatorapi.entities.SummaryResultWithIssueMessages;
import eu.dnetlib.validatorapi.entities.ValidationIssue;
import eu.dnetlib.validatorapi.entities.ValidationRuleResult;
import eu.dnetlib.validatorapi.entities.XmlValidationResponse;
import eu.dnetlib.validatorapi.utils.ProfileInitializer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

@RestController
@CrossOrigin(origins={"*"})
public class ValidatorController {
    private final Logger log = LogManager.getLogger(this.getClass());

    @RequestMapping(value={"/validateRecord"}, method={RequestMethod.POST})
    public XmlValidationResponse validateRecord(@RequestParam(name="guidelines") String guidelinesProfileName, @RequestBody String xml) {
        XmlValidationResponse xmlValidationResponse = new XmlValidationResponse();
        AbstractOpenAireProfile profile = ProfileInitializer.initializeOpenAireProfile((String)guidelinesProfileName);
        AbstractOpenAireProfile fairProfile = ProfileInitializer.initializeFairProfileByGuideline((String)guidelinesProfileName);
        if (profile == null && fairProfile == null) {
            this.log.error("Exception: No valid guidelines");
            new Exception("Validation stopped unexpectedly. No valid guidelines were provided.");
        }
        LinkedHashMap scorePerDoc = new LinkedHashMap();
        ArrayList validationIssues = new ArrayList();
        ArrayList summaryResults = new ArrayList();
        try {
            ValidationRuleResult validationRuleResult;
            String ruleName;
            StandardResult engineResult;
            Map results;
            StandardValidationResult validationResult;
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = dbf.newDocumentBuilder();
            Document doc = documentBuilder.parse(new InputSource(new StringReader(xml)));
            if (profile != null) {
                validationResult = profile.validate("id", doc);
                results = validationResult.getResults();
                for (Map.Entry entry : results.entrySet()) {
                    engineResult = (StandardResult)entry.getValue();
                    ruleName = entry.getKey().toString();
                    validationRuleResult = new ValidationRuleResult();
                    this.constructXmlValidationResponse(xmlValidationResponse, validationRuleResult, profile.name(), ruleName, profile, engineResult);
                }
            }
            if (fairProfile != null) {
                validationResult = fairProfile.validate("id", doc);
                results = validationResult.getResults();
                for (Map.Entry entry : results.entrySet()) {
                    engineResult = (StandardResult)entry.getValue();
                    ruleName = entry.getKey().toString();
                    validationRuleResult = new ValidationRuleResult();
                    this.constructXmlValidationResponse(xmlValidationResponse, validationRuleResult, profile.name(), ruleName, profile, engineResult);
                }
            }
        }
        catch (Exception e) {
            this.log.debug(e.getMessage());
            this.log.debug((Object)e);
            e.printStackTrace();
        }
        return xmlValidationResponse;
    }

    private XmlValidationResponse constructXmlValidationResponse(XmlValidationResponse xmlValidationResponse, ValidationRuleResult validationRuleResult, String guidelines, String ruleName, AbstractOpenAireProfile profile, StandardResult engineResult) {
        ValidationIssue validationIssue;
        SummaryResultWithIssueMessages summaryResult = new SummaryResultWithIssueMessages();
        summaryResult.ruleName = ruleName;
        summaryResult.validationJobId = -1;
        summaryResult.guidelines = guidelines;
        validationRuleResult.score = engineResult.getScore();
        summaryResult.rule_status = engineResult.getStatus().toString();
        summaryResult.passed_records = 1L;
        if (profile.guideline(ruleName) != null) {
            summaryResult.rule_weight = profile.guideline(ruleName).getWeight();
            if (profile.guideline(ruleName).getRequirementLevel() != null && profile.guideline(ruleName).getRequirementLevel().name() != null) {
                summaryResult.requirement_level = profile.guideline(ruleName).getRequirementLevel().name();
            }
            if (profile.guideline(ruleName).getDescription() != null) {
                summaryResult.description = profile.guideline(ruleName).getDescription();
            }
            if (profile.guideline(ruleName).getFairPrinciples() != null) {
                summaryResult.fair_principles = profile.guideline(ruleName).getFairPrinciples();
            }
            if (profile.guideline(ruleName).getLink() != null) {
                summaryResult.link = profile.guideline(ruleName).getLink();
            }
        }
        summaryResult.internal_error = engineResult.getInternalError();
        summaryResult.has_warnings = engineResult.getWarnings().size() > 0;
        summaryResult.has_errors = engineResult.getErrors().size() > 0;
        xmlValidationResponse.getSummaryResults().add(summaryResult);
        for (ValidationProblem error : engineResult.getErrors()) {
            validationIssue = new ValidationIssue(ruleName, error.getMessage(), "ERROR");
            summaryResult.issues.add(validationIssue);
        }
        for (ValidationProblem warning : engineResult.getWarnings()) {
            validationIssue = new ValidationIssue(ruleName, warning.getMessage(), "WARNING");
            summaryResult.issues.add(validationIssue);
        }
        return xmlValidationResponse;
    }
}

