/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validatorapi.controllers;

import eu.dnetlib.validator2.validation.guideline.Guideline;
import eu.dnetlib.validator2.validation.guideline.openaire.AbstractOpenAireProfile;
import eu.dnetlib.validator2.validation.guideline.openaire.FAIR_Data_GuidelinesProfile;
import eu.dnetlib.validator2.validation.guideline.openaire.FAIR_Literature_GuidelinesV4Profile;
import eu.dnetlib.validatorapi.utils.ProfileInitializer;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.w3c.dom.Document;

@RestController
@CrossOrigin(origins={"*"})
@RequestMapping(value={"/rules"})
public class RuleController {
    @RequestMapping(value={"/"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<Collection<Guideline<Document>>> getRules() {
        Collection guidelinesLiteratureV3 = new FAIR_Literature_GuidelinesV4Profile().guidelines();
        Collection guidelinesLiteratureV4 = new FAIR_Literature_GuidelinesV4Profile().guidelines();
        Collection guidelinesData = new FAIR_Data_GuidelinesProfile().guidelines();
        ArrayList allGuidelines = new ArrayList();
        allGuidelines.addAll(guidelinesData);
        allGuidelines.addAll(guidelinesLiteratureV3);
        allGuidelines.addAll(guidelinesLiteratureV4);
        return ResponseEntity.ok(allGuidelines);
    }

    @RequestMapping(value={"/guideline/{guidelinesProfileName}"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<Collection<Guideline<Document>>> getRulesByGuideline(@PathVariable(value="guidelinesProfileName") String guidelinesProfileName) {
        AbstractOpenAireProfile profile = ProfileInitializer.initializeFairProfileByGuideline((String)guidelinesProfileName);
        if (profile != null) {
            Collection guidelines = profile.guidelines();
            return ResponseEntity.ok(new ArrayList(guidelines));
        }
        return ResponseEntity.notFound().build();
    }

    @RequestMapping(value={"/fairGuideline/{fairGuidelinesProfileName}"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<Collection<Guideline<Document>>> getRulesByFairGuideline(@PathVariable(value="fairGuidelinesProfileName") String fairGuidelinesProfileName) {
        AbstractOpenAireProfile profile = ProfileInitializer.initializeFairProfileByName((String)fairGuidelinesProfileName);
        if (profile != null) {
            Collection guidelines = profile.guidelines();
            return ResponseEntity.ok(new ArrayList(guidelines));
        }
        return ResponseEntity.notFound().build();
    }

    @RequestMapping(value={"/type/{type}"}, method={RequestMethod.GET}, produces={"application/json"})
    public ResponseEntity<Collection<Guideline<Document>>> getRulesByType(@PathVariable(value="type") String type) {
        AbstractOpenAireProfile profile = ProfileInitializer.initializeFairProfileByType((String)type);
        if (profile != null) {
            Collection guidelines = profile.guidelines();
            return ResponseEntity.ok(new ArrayList(guidelines));
        }
        return ResponseEntity.notFound().build();
    }
}

