/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validatorapi.routes;

import eu.dnetlib.validatorapi.processors.SetsProcessor;
import java.net.UnknownHostException;
import java.util.concurrent.TimeoutException;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.TypeConversionException;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.engine.DefaultShutdownStrategy;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.apache.http.client.ClientProtocolException;
import org.springframework.stereotype.Component;

@Component
public class OaiSetListRoute
extends RouteBuilder {
    public void configure() throws Exception {
        DefaultShutdownStrategy shutdownStrategy = (DefaultShutdownStrategy)this.getContext().getShutdownStrategy();
        shutdownStrategy.setTimeout(1L);
        this.onException(TypeConversionException.class).maximumRedeliveries(0).handled(true).end();
        this.onException(ClientProtocolException.class).maximumRedeliveries(0).handled(true).end();
        this.onException(UnknownHostException.class).maximumRedeliveries(0).handled(true).end();
        this.onException(ClientProtocolException.class).maximumRedeliveries(0).handled(true).end();
        this.onException(TimeoutException.class).handled(true).process(exchange -> {
            exchange.getMessage().setHeader("CamelHttpResponseCode", (Object)408);
            exchange.getMessage().setHeader("Content-Type", (Object)"application/json");
            exchange.getIn().setBody((Object)"{\"error_code\":\"408\",\"message\":\"Unable to retrieve sets. Server response takes too long.\"}");
        });
        ((ExpressionNode)((RouteDefinition)this.from("direct:getResponse").routeId("myRoute").process(exchange -> {
            String endpoint = (String)exchange.getIn().getHeader("endpoint", String.class);
            exchange.getIn().setHeader("dynamicEndpoint", (Object)endpoint);
        })).recipientList((Expression)this.header("dynamicEndpoint")).parallelProcessing().timeout(20000L).process((Processor)new SetsProcessor())).end();
    }
}

