/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validatorapi.processors;

import eu.dnetlib.validatorapi.entities.SummaryResult;
import eu.dnetlib.validatorapi.repositories.SummaryValidationJobRepository;
import eu.dnetlib.validatorapi.repositories.ValidationResultRepository;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;

public class SummaryValidationJobProcessor
implements Processor {
    private final ValidationResultRepository validationResultRepository;
    private final SummaryValidationJobRepository summaryValidationJobRepository;
    private final String routeId;

    public SummaryValidationJobProcessor(ValidationResultRepository validationResultRepository, SummaryValidationJobRepository summaryValidationJobRepository, String routeId) {
        this.validationResultRepository = validationResultRepository;
        this.summaryValidationJobRepository = summaryValidationJobRepository;
        this.routeId = routeId;
    }

    public void process(Exchange exchange) throws Exception {
        int validation_job_id = (Integer)exchange.getIn().getHeader("validationId");
        List summaryResults = this.validationResultRepository.getFullSummaryResult(((Integer)exchange.getIn().getHeader("validationId")).intValue());
        for (SummaryResult sr : summaryResults) {
            sr.validationJobId = validation_job_id;
            this.summaryValidationJobRepository.save((Object)sr);
        }
        this.validationResultRepository.customDelete(validation_job_id);
        exchange.getIn().setHeader("CamelControlBusAction", (Object)"stop");
        exchange.getIn().setHeader("CamelControlBusRouteId", (Object)this.routeId);
    }
}

