/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validatorapi.processors;

import eu.dnetlib.validator.domain.Progress;
import eu.dnetlib.validatorapi.entities.ValidationJob;
import java.util.Date;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.springframework.stereotype.Component;

@Component
public class ExceptionProcessor
implements Processor {
    public void process(Exchange exchange) {
        ValidationJob validationJob = (ValidationJob)exchange.getIn().getHeader("ValidationJob");
        Throwable caused = (Throwable)exchange.getProperty("CamelExceptionCaught", Exception.class);
        if (caused != null) {
            System.out.println("Caught Exception: " + String.valueOf(caused));
            System.out.println("Exception class: " + String.valueOf(caused.getClass()));
            System.out.println("Exception message: " + caused.getMessage());
            System.out.println("Exception cause: " + String.valueOf(caused.getCause()));
            if (caused.getClass() != null && caused.getClass().getName() != null) {
                validationJob.exceptionClass = caused.getClass().getName();
            }
            if (caused.getMessage() != null) {
                validationJob.exceptionMessage = caused.getMessage();
            }
            if (caused.getCause() != null && caused.getCause().getMessage() != null) {
                validationJob.exceptionMessage = caused.getMessage();
            }
        }
        validationJob.progress = Progress.STOPPED;
        validationJob.endDate = new Date();
        exchange.getIn().setBody((Object)validationJob, ValidationJob.class);
    }
}

