/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.validation.utils;

import eu.dnetlib.validator2.engine.RuleValidationResult;
import eu.dnetlib.validator2.engine.TestResultPredicate;
import eu.dnetlib.validator2.validation.utils.ISOLangCodes;

public class ISO639ValuePredicate
implements TestResultPredicate<String> {
    @Override
    public RuleValidationResult test(String s) {
        if (s == null || s.isEmpty()) {
            return RuleValidationResult.failure("input string is null or empty", "Provide a valid ISO 639 language code.");
        }
        if (ISOLangCodes.contains(s)) {
            return RuleValidationResult.success();
        }
        return RuleValidationResult.failure("value '" + s + "' is not a valid ISO 639 language code", "Use a valid ISO 639-1, 639-2, or 639-3 language code.");
    }
}

