/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.validation.guideline.openaire;

import eu.dnetlib.validator2.validation.guideline.Builders;
import eu.dnetlib.validator2.validation.guideline.Cardinality;
import eu.dnetlib.validator2.validation.guideline.ElementSpec;
import eu.dnetlib.validator2.validation.guideline.Guideline;
import eu.dnetlib.validator2.validation.guideline.SyntheticGuideline;
import eu.dnetlib.validator2.validation.guideline.openaire.AbstractOpenAireProfile;
import eu.dnetlib.validator2.validation.utils.RegexValuePredicate;
import eu.dnetlib.validator2.validation.utils.SupportedRegExs;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.w3c.dom.Document;

public final class F2_01M
extends AbstractOpenAireProfile {
    private static final String[] TITLE_TYPES = new String[]{"AlternativeTitle", "Subtitle", "TranslatedTitle", "Other"};
    private static final String[] NAME_TYPES = new String[]{"Organizational", "Personal"};
    private static final ElementSpec F2_01M_SPEC_1 = Builders.forMandatoryElement("creator", Cardinality.ONE_TO_N).withSubElement(Builders.forMandatoryElement("creatorName", Cardinality.ONE)).withSubElement(Builders.forRecommendedElement("nameIdentifier").withRecommendedAttribute("nameIdentifierScheme").withRecommendedAttribute("schemeURI")).withSubElement(Builders.forRecommendedRepeatableElement("affiliation")).build();
    private static final ElementSpec F2_01M_SPEC_2 = Builders.forMandatoryElement("title", Cardinality.ONE_TO_N).withOptionalAttribute("titleType", TITLE_TYPES).build();
    private static final ElementSpec F2_01M_SPEC_3 = Builders.forMandatoryElement("publisher", Cardinality.ONE_TO_N).build();
    private static final ElementSpec F2_01M_SPEC_4 = Builders.forMandatoryElement("date", Cardinality.ONE_TO_N).allowedValues(new RegexValuePredicate(SupportedRegExs.COMPILED_ISO_8601_DATE_REG_EX)).withMandatoryAttribute("dateType", "Issued").build();
    private static final ElementSpec F2_01M_SPEC_5 = Builders.forMandatoryElement("description", Cardinality.ONE_TO_N).withMandatoryAttribute("descriptionType", "Abstract").build();
    private static final ElementSpec F2_01M_SPEC_6 = Builders.forMandatoryElement("subject", Cardinality.ONE_TO_N).withOptionalAttribute("subjectScheme").withOptionalAttribute("schemeURI").build();
    public static SyntheticGuideline F2_01M_1 = SyntheticGuideline.of("Creator", 2, F2_01M_SPEC_1);
    public static SyntheticGuideline F2_01M_2 = SyntheticGuideline.of("Title", 2, F2_01M_SPEC_2);
    public static SyntheticGuideline F2_01M_3 = SyntheticGuideline.of("Publisher", 2, F2_01M_SPEC_3);
    public static SyntheticGuideline F2_01M_4 = SyntheticGuideline.of("Date", 2, F2_01M_SPEC_4);
    public static SyntheticGuideline F2_01M_5 = SyntheticGuideline.of("Summary (Description with descriptionType)", 2, F2_01M_SPEC_5);
    public static SyntheticGuideline F2_01M_6 = SyntheticGuideline.of("Keywords (Subject)", 2, F2_01M_SPEC_6);
    private static final List<Guideline<Document>> GUIDELINES = Collections.unmodifiableList(Arrays.asList(F2_01M_1, F2_01M_2, F2_01M_3, F2_01M_4, F2_01M_5, F2_01M_6));
    private static final Map<String, Guideline> GUIDELINE_MAP = GUIDELINES.stream().collect(Collectors.toMap(Guideline::getName, guideline -> guideline));
    private static final int MAX_SCORE = GUIDELINES.stream().map(Guideline::getWeight).reduce(0, Integer::sum);

    public F2_01M() {
        super("Rich metadata is provided to allow discovery");
    }

    @Override
    public Collection<? extends Guideline<Document>> guidelines() {
        return GUIDELINES;
    }

    public Guideline guideline(String guidelineName) {
        return GUIDELINE_MAP.get(guidelineName);
    }

    @Override
    public int maxScore() {
        return MAX_SCORE;
    }
}

