/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.engine;

import eu.dnetlib.validator2.engine.Helper;
import eu.dnetlib.validator2.engine.Rule;
import eu.dnetlib.validator2.engine.RuleValidationResult;
import eu.dnetlib.validator2.engine.TestResultPredicate;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Predicates {
    public static <T> Predicate<T> all(Iterable<Rule<T>> rules) {
        return t -> {
            for (Rule rule : rules) {
                if (rule.test(t).isSuccess()) continue;
                return false;
            }
            return true;
        };
    }

    public static <T> Predicate<T> any(Iterable<Rule<T>> rules) {
        return t -> {
            for (Rule rule : rules) {
                if (!rule.test(t).isSuccess()) continue;
                return true;
            }
            return false;
        };
    }

    public static <T> Predicate<T> not(Rule<T> rule) {
        return t -> !rule.test(t).isSuccess();
    }

    public static class SetOfCaseInsensitiveAllowedValues
    implements TestResultPredicate<String> {
        private final Set<String> allowedValues;

        public SetOfCaseInsensitiveAllowedValues(String[] allowedValues) {
            this.allowedValues = Stream.of(allowedValues).filter(Objects::nonNull).map(String::trim).filter(term -> !term.isEmpty()).map(String::toLowerCase).collect(Collectors.toCollection(HashSet::new));
        }

        @Override
        public RuleValidationResult test(String s) {
            String textToTest = Helper.canonicalize(s);
            if (textToTest.isEmpty()) {
                return RuleValidationResult.failure("input string is empty", "Provide a non-empty value from the allowed set.");
            }
            if (this.allowedValues.contains(textToTest.toLowerCase())) {
                return RuleValidationResult.success();
            }
            return RuleValidationResult.failure("value '" + s + "' is not in the set of allowed values", "Use one of the allowed values: " + String.join((CharSequence)", ", this.allowedValues));
        }

        public boolean isEmpty() {
            return this.allowedValues.isEmpty();
        }

        public String toString() {
            return "SetOfCaseInsensitiveAllowedValues{allowedValues=" + this.allowedValues + '}';
        }
    }
}

