package eu.dnetlib.validator2.validation.guideline.openaire;

import eu.dnetlib.validator2.engine.TestResultPredicate;
import eu.dnetlib.validator2.validation.guideline.Builders;
import eu.dnetlib.validator2.validation.guideline.ElementSpec;
import eu.dnetlib.validator2.validation.guideline.Guideline;
import eu.dnetlib.validator2.validation.guideline.SyntheticGuideline;
import eu.dnetlib.validator2.validation.utils.RegexValuePredicate;
import org.w3c.dom.Document;

import java.util.*;
import java.util.stream.Collectors;

import static eu.dnetlib.validator2.validation.guideline.Cardinality.ONE_TO_N;
import static eu.dnetlib.validator2.validation.utils.SupportedRegExs.*;

public final class F3_01M_LIT_v3 extends AbstractOpenAireProfile {

    private static final String[] publicationVersions = {
            "info:eu-repo/semantics/draft",
            "info:eu-repo/semantics/submittedVersion",
            "info:eu-repo/semantics/acceptedVersion",
            "info:eu-repo/semantics/publishedVersion",
            "info:eu-repo/semantics/updateVersion"
    };

//    private static final ElementSpec F3_01M_LIT_v3_SPEC_1 = Builders.
//            forMandatoryElement("dc:type", ONE_TO_N).
//            allowedValues(publicationVersions).
//            build();

    private static final ElementSpec F3_01M_LIT_v3_SPEC_2 = Builders.
            forMandatoryElement("dc:relation", ONE_TO_N).
            allowedValues(relationSpecAllowedValuesPredicate()).
            build();

    private static TestResultPredicate<String> relationSpecAllowedValuesPredicate() {
        return new RegexValuePredicate(COMPILED_PROJECT_IDENTIFIER_REGEX).negate()
                .and(new RegexValuePredicate(COMPILED_ALT_IDENTIFIER_REG_EX).negate())
                .and(new RegexValuePredicate(COMPILED_PUBLICATION_REFERENCE_REG_EX).negate())
                .and(new RegexValuePredicate(COMPILED_DATASET_REFERENCE_REG_EX).negate());
    }
    //TODO: weights for guidelines haven't been finalized. They've been given an arbitrary value of 1.
//    public static SyntheticGuideline F3_01M_LIT_v3_1 = SyntheticGuideline.of("Version", 1, F3_01M_LIT_v3_SPEC_1);
    public static SyntheticGuideline F3_01M_LIT_v3_2 = SyntheticGuideline.of("RelatedIdentifier", 1, F3_01M_LIT_v3_SPEC_2);
    private static final List<Guideline<Document>> GUIDELINES = Collections.unmodifiableList(
            Arrays.asList(
//                    F3_01M_LIT_v3_1,
                    F3_01M_LIT_v3_2
            )
    );

    private static final Map<String, Guideline> GUIDELINE_MAP = GUIDELINES.
            stream().
            collect(Collectors.toMap(Guideline::getName, (guideline) -> guideline));

    private static final int MAX_SCORE = GUIDELINES.stream().map(Guideline::getWeight).reduce(0, Integer::sum);

    public F3_01M_LIT_v3() {
        super("metadata clearly and explicitly include the identifier of the data it describes");
    }

    @Override
    public Collection<? extends Guideline<Document>> guidelines() {
        return GUIDELINES;
    }

    /**
     * @param guidelineName
     * @return
     */
    @Override
    public Guideline guideline(String guidelineName) {
        return GUIDELINE_MAP.get(guidelineName);
    }

    @Override
    public int maxScore() {
        return MAX_SCORE;
    }
}