package eu.dnetlib.validator2.engine;

public class RuleValidationResult {

    private final boolean status;
    private final String message;
    private final String suggestion;

    private RuleValidationResult(boolean status, String message, String suggestion) {
        this.status = status;
        this.message = message;
        this.suggestion = suggestion;
    }

    public boolean isSuccess() {
        return status;
    }

    public String getMessage() {
        return message;
    }

    public String getSuggestion() {
        return suggestion;
    }

    public static RuleValidationResult success() {
        return new RuleValidationResult(true, null, null);
    }

    public static RuleValidationResult failure(String message, String suggestion) {
        if ( message == null || message.trim().isEmpty() )
            throw new IllegalArgumentException("Failure message cannot be null or empty.");
        else
            return new RuleValidationResult(false, message, suggestion);
    }
}
