package eu.dnetlib.validator2.engine;

public class RuleEngine {

    public static <T, R extends Rule<T>> void applyAndReport(R rule, T t, Reporter<T, R> reporter) throws IllegalArgumentException
    {
        if (reporter == null) throw new IllegalArgumentException("Reporter cannot be null");
        if (rule == null) throw new IllegalArgumentException("Rule cannot be null");

        try {
            RuleValidationResult result = rule.test(t);
            if ( result.isSuccess() )
                reporter.reportSuccessFor(rule, t);
            else
                reporter.reportFailureFor(rule, t, result.getMessage(), result.getSuggestion());
        } catch (Throwable throwable) {
            reporter.reportErrorFor(rule, t, throwable);
        }
    }

}
