/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.validation.guideline.openaire;

import eu.dnetlib.validator2.result_models.RequirementLevel;
import eu.dnetlib.validator2.result_models.StandardResult;
import eu.dnetlib.validator2.result_models.StandardValidationResult;
import eu.dnetlib.validator2.validation.guideline.AbstractGuideline;
import eu.dnetlib.validator2.validation.guideline.openaire.I2_01M;
import eu.dnetlib.validator2.validation.utils.ResultUtils;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

class I2_01M_SPEC
extends AbstractGuideline<Document> {
    private static final Logger logger = LoggerFactory.getLogger(I2_01M_SPEC.class);

    public I2_01M_SPEC() {
        super("(meta)data use vocabularies that follow FAIR principles", "I2", "description", "https://w3id.org/fair/principles/latest/I2", "I", 10, RequirementLevel.MANDATORY);
    }

    public StandardResult validate(String id, Document t) {
        I2_01M profile = new I2_01M();
        try {
            logger.debug("Metadata uses FAIR-compliant vocabularies");
            StandardValidationResult res_F = profile.validate(id, t);
            Map results = res_F.getResults();
            int MaxScoreI2_01M_SPEC = (int)res_F.getScore() == 50 ? (int)(2.0 * res_F.getScore() * (double)this.getWeight() / 100.0) : (int)(res_F.getScore() * (double)this.getWeight() / 100.0);
            StandardResult ress = I2_01M_SPEC.getResult(results.entrySet(), MaxScoreI2_01M_SPEC);
            return new StandardResult(ress.getScore(), ress.getStatus(), ress.getWarnings(), ress.getErrors(), ress.getInternalError());
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }

    private static StandardResult getResult(Set<Map.Entry<String, StandardResult>> data, int score) {
        return ResultUtils.getNewResult(data, score);
    }
}

