/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.validation.guideline.openaire;

import eu.dnetlib.validator2.validation.guideline.Builders;
import eu.dnetlib.validator2.validation.guideline.Cardinality;
import eu.dnetlib.validator2.validation.guideline.ElementPosition;
import eu.dnetlib.validator2.validation.guideline.ElementSpec;
import eu.dnetlib.validator2.validation.guideline.Guideline;
import eu.dnetlib.validator2.validation.guideline.SyntheticGuideline;
import eu.dnetlib.validator2.validation.guideline.openaire.AbstractOpenAireProfile;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.w3c.dom.Document;

public final class I2_01M_LIT_v3
extends AbstractOpenAireProfile {
    private static final String[] repoAccessTerms = new String[]{"info:eu-repo/semantics/closedAccess", "info:eu-repo/semantics/embargoedAccess", "info:eu-repo/semantics/restrictedAccess", "info:eu-repo/semantics/openAccess"};
    private static final String[] publicationTypes = new String[]{"info:eu-repo/semantics/article", "info:eu-repo/semantics/bachelorThesis", "info:eu-repo/semantics/masterThesis", "info:eu-repo/semantics/doctoralThesis", "info:eu-repo/semantics/book", "info:eu-repo/semantics/bookPart", "info:eu-repo/semantics/review", "info:eu-repo/semantics/conferenceObject", "info:eu-repo/semantics/lecture", "info:eu-repo/semantics/workingPaper", "info:eu-repo/semantics/preprint", "info:eu-repo/semantics/report", "info:eu-repo/semantics/annotation", "info:eu-repo/semantics/contributionToPeriodical", "info:eu-repo/semantics/patent", "info:eu-repo/semantics/other"};
    private static final ElementSpec RESOURCE_TYPE_SPEC = Builders.forMandatoryElement("dc:type", Cardinality.ONE).atPosition(ElementPosition.FIRST).allowedValues(publicationTypes).build();
    private static final ElementSpec ACCESS_RIGHTS_SPEC = Builders.forMandatoryElement("dc:rights", Cardinality.ONE).allowedValues(repoAccessTerms).build();
    public static SyntheticGuideline I2_01M_LIT_v3_1 = SyntheticGuideline.of("Resource Type", 1, RESOURCE_TYPE_SPEC);
    public static SyntheticGuideline I2_01M_LIT_v3_3 = SyntheticGuideline.of("Rights", 1, ACCESS_RIGHTS_SPEC);
    private static final List<Guideline<Document>> GUIDELINES = Collections.unmodifiableList(Arrays.asList(I2_01M_LIT_v3_1, I2_01M_LIT_v3_3));
    private static final Map<String, Guideline> GUIDELINE_MAP = GUIDELINES.stream().collect(Collectors.toMap(Guideline::getName, guideline -> guideline));
    private static final int MAX_SCORE = GUIDELINES.stream().map(Guideline::getWeight).reduce(0, Integer::sum);

    public I2_01M_LIT_v3() {
        super("(meta)data use vocabularies that follow FAIR principles");
    }

    @Override
    public Collection<? extends Guideline<Document>> guidelines() {
        return GUIDELINES;
    }

    public Guideline guideline(String guidelineName) {
        return GUIDELINE_MAP.get(guidelineName);
    }

    @Override
    public int maxScore() {
        return MAX_SCORE;
    }
}

