package eu.dnetlib.validator2.validation.utils;

import eu.dnetlib.validator2.engine.RuleValidationResult;
import eu.dnetlib.validator2.engine.TestResultPredicate;

import java.util.regex.Pattern;

public class RegexValuePredicate implements TestResultPredicate<String> {
    private final Pattern pattern;

    public RegexValuePredicate(Pattern pattern) {
        this.pattern = pattern;
    }

    @Override
    public RuleValidationResult test(String s) {
        if ( s == null || s.isEmpty() )
            return RuleValidationResult.failure("input string is null or empty", "Provide a non-empty value.");
        else if (pattern.matcher(s).matches())
            return RuleValidationResult.success();
        else
            return RuleValidationResult.failure("value '" + s + "' does not match regular expression '" + pattern.pattern() + "'", "Ensure the value conforms to the specified regular expression.");
    }
}
