package eu.dnetlib.validator2.validation.guideline;

import eu.dnetlib.validator2.result_models.RequirementLevel;
import eu.dnetlib.validator2.result_models.Result;

import java.io.Serializable;

public interface Guideline<T> extends Serializable {

    String getName();

    String getFairRuleId();

    String getDescription();

    String getLink();

    String getFairPrinciples();

    int getWeight(); //that's the "score" of the guideline if it succeeds

    RequirementLevel getRequirementLevel();

    default Result validate(T t) {
        return validate(t == null ? "Object" : t.getClass().getSimpleName(), t);
    }

    Result validate(String id, T t);
}
