package eu.dnetlib.validator2.engine;

import java.util.Objects;

@FunctionalInterface
public interface TestResultPredicate<T> {
    RuleValidationResult test(T t);

    default TestResultPredicate<T> or(TestResultPredicate<? super T> other) {
        Objects.requireNonNull(other);
        return (t) -> {
            RuleValidationResult result = test(t);
            if ( result.isSuccess() )
                return result;
            else
                return other.test(t);
        };
    }

    default TestResultPredicate<T> and(TestResultPredicate<? super T> other) {
        Objects.requireNonNull(other);
        return (t) -> {
            RuleValidationResult result = test(t);
            if ( !result.isSuccess() )
                return result;
            else
                return other.test(t);
        };
    }

    default TestResultPredicate<T> negate() {
        return (t) -> {
            RuleValidationResult result = test(t);
            if ( result.isSuccess() )
                return RuleValidationResult.failure("predicate was not expected to succeed", "The value should not pass this validation check.");
            else
                return RuleValidationResult.success();
        };
    }
}
