/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.validator2.validation.guideline.openaire;

import eu.dnetlib.validator2.result_models.RequirementLevel;
import eu.dnetlib.validator2.result_models.StandardResult;
import eu.dnetlib.validator2.result_models.StandardValidationResult;
import eu.dnetlib.validator2.validation.guideline.AbstractGuideline;
import eu.dnetlib.validator2.validation.guideline.openaire.DataArchiveGuidelinesV2Profile;
import eu.dnetlib.validator2.validation.utils.ResultUtils;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

class R1_3_01M_SPEC
extends AbstractGuideline<Document> {
    private static final Logger logger = LoggerFactory.getLogger(R1_3_01M_SPEC.class);

    public R1_3_01M_SPEC() {
        super("(meta)data meet domain-relevant community standards", "R1.3", "description", "https://w3id.org/fair/principles/latest/R1.3", "R", 10, RequirementLevel.MANDATORY);
    }

    public StandardResult validate(String id, Document t) {
        DataArchiveGuidelinesV2Profile profile = new DataArchiveGuidelinesV2Profile();
        try {
            StandardValidationResult res_F = profile.validate(id, t);
            Map results = res_F.getResults();
            int MaxScoreR1_3_01M_SPEC = (int)(res_F.getScore() * (double)this.getWeight() / 100.0);
            StandardResult ress = R1_3_01M_SPEC.getResult(results.entrySet(), MaxScoreR1_3_01M_SPEC);
            return new StandardResult(ress.getScore(), ress.getStatus(), ress.getWarnings(), ress.getErrors(), ress.getInternalError());
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }

    private static StandardResult getResult(Set<Map.Entry<String, StandardResult>> data, int score) {
        return ResultUtils.getNewResult(data, score);
    }
}

