/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.uoamonitorservice.generics;

import eu.dnetlib.uoamonitorservice.annotations.Children;
import eu.dnetlib.uoamonitorservice.annotations.Overridable;
import eu.dnetlib.uoamonitorservice.annotations.Unmodifiable;
import eu.dnetlib.uoamonitorservice.common.Common;
import eu.dnetlib.uoamonitorservice.primitives.IndicatorType;
import eu.dnetlib.uoamonitorservice.primitives.Labelled;
import eu.dnetlib.uoamonitorservice.utils.EnumUtils;
import java.util.ArrayList;
import java.util.List;

public class SectionGeneric<T>
extends Common {
    @Overridable
    protected String title;
    @Unmodifiable
    protected IndicatorType type;
    @Children
    @Unmodifiable
    @Overridable(restorable=false)
    protected List<T> indicators;

    public SectionGeneric() {
    }

    public SectionGeneric(SectionGeneric<?> section) {
        super(section);
        this.title = section.getTitle();
        this.setType(section.getType());
        this.indicators = new ArrayList();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getType() {
        return EnumUtils.toLabel((Labelled)this.type);
    }

    public void setType(String type) {
        this.type = IndicatorType.fromLabel((String)type);
    }

    public boolean isNumber() {
        return this.type == IndicatorType.NUMBER;
    }

    public List<T> getIndicators() {
        return this.indicators;
    }

    public void setIndicators(List<T> indicators) {
        this.indicators = indicators;
    }
}

