/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.services;

import eu.dnetlib.dto.request.EntityRequest;
import eu.dnetlib.dto.request.FacetRequest;
import eu.dnetlib.dto.request.ServiceRequest;
import eu.dnetlib.dto.response.CustomSolrResponse;
import eu.dnetlib.exception.DocumentNotFoundException;
import eu.dnetlib.mappers.request.ServiceRequestMapper;
import eu.dnetlib.mappers.response.CustomSolrResponseMapper;
import eu.dnetlib.mappers.solr.CustomSolrParamsMapper;
import eu.dnetlib.repository.SolrRepository;
import eu.dnetlib.solr.CustomSolrParams;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ServiceService {
    @Autowired
    SolrRepository solrRepository;
    @Autowired
    ServiceRequestMapper mapper;
    @Autowired
    CustomSolrParamsMapper customSolrParamsMapper;
    @Autowired
    CustomSolrResponseMapper customSolrResponseMapper;

    public String getById(ServiceRequest serviceRequest) {
        CustomSolrParams customSolrParams = this.customSolrParamsMapper.toCustomIdSolrParams((EntityRequest)serviceRequest);
        QueryResponse queryResponse = this.solrRepository.query(customSolrParams);
        if (queryResponse.getResults() != null && queryResponse.getResults().size() < 1 || queryResponse.getResults().isEmpty()) {
            throw new DocumentNotFoundException("Service with id: " + serviceRequest.getId()[0] + " not found.");
        }
        return this.customSolrResponseMapper.toSingleEntityResponse(queryResponse).getRecord();
    }

    public CustomSolrResponse search(ServiceRequest serviceRequest) {
        CustomSolrParams customSolrParams = this.customSolrParamsMapper.toCustomSolrParams((EntityRequest)serviceRequest);
        QueryResponse queryResponse = this.solrRepository.query(customSolrParams);
        return this.customSolrResponseMapper.toCustomSolrResponse(queryResponse, (EntityRequest)serviceRequest, customSolrParams);
    }

    public CustomSolrResponse facetSearch(ServiceRequest serviceRequest, FacetRequest facetRequest, Integer facetLimit) {
        CustomSolrParams customSolrParams = this.customSolrParamsMapper.toCustomSolrParams((EntityRequest)serviceRequest, facetRequest, facetLimit);
        QueryResponse queryResponse = this.solrRepository.query(customSolrParams);
        return this.customSolrResponseMapper.toCustomSolrResponse(queryResponse, (EntityRequest)serviceRequest, customSolrParams);
    }

    public CustomSolrResponse internalFacetSearch(ServiceRequest serviceRequest, FacetRequest facetRequest) {
        CustomSolrParams customSolrParams = this.customSolrParamsMapper.toCustomSolrParamsForBrowseAll((EntityRequest)serviceRequest, facetRequest);
        QueryResponse queryResponse = this.solrRepository.query(customSolrParams);
        return this.customSolrResponseMapper.toCustomSolrResponse(queryResponse, (EntityRequest)serviceRequest, customSolrParams);
    }
}

