/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.controllers;

import eu.dnetlib.dto.request.ResearchProductRequest;
import eu.dnetlib.dto.request.SygmaRequest;
import eu.dnetlib.mappers.request.SygmaRequestMapper;
import eu.dnetlib.services.ResearchProductService;
import eu.dnetlib.services.SygmaService;
import java.io.IOException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sygma"})
public class SygmaController {
    @Autowired
    ResearchProductService researchProductService;
    @Autowired
    SygmaRequestMapper sygmaMapper;
    @Autowired
    SygmaService sygmaService;

    @GetMapping(value={"/publications"}, produces={"application/xml"})
    public String listPublications(@ModelAttribute SygmaRequest sygmaRequest) throws IOException {
        this.generateCompliantPageParameter(sygmaRequest);
        ResearchProductRequest researchProductRequest = this.sygmaMapper.toResearchProductRequest(sygmaRequest);
        researchProductRequest.setType(new String[]{"publication"});
        return this.sygmaService.searchPublications(researchProductRequest);
    }

    @GetMapping(value={"/datasets"}, produces={"application/xml"})
    public String listDatasets(@ModelAttribute SygmaRequest sygmaRequest) throws IOException {
        this.generateCompliantPageParameter(sygmaRequest);
        ResearchProductRequest researchProductRequest = this.sygmaMapper.toResearchProductRequest(sygmaRequest);
        researchProductRequest.setType(new String[]{"dataset"});
        return this.sygmaService.searchDatasets(researchProductRequest);
    }

    public void generateCompliantPageParameter(SygmaRequest sygmaRequest) {
        if (sygmaRequest.getPage() > 0) {
            sygmaRequest.setPage(Integer.valueOf(sygmaRequest.getPage() - 1));
        } else {
            sygmaRequest.setPage(Integer.valueOf(0));
        }
    }
}

