/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.controllers;

import eu.dnetlib.controllers.EntityController;
import eu.dnetlib.dto.request.FacetRequest;
import eu.dnetlib.dto.request.ProjectRequest;
import eu.dnetlib.dto.request.ResearchProductRequest;
import eu.dnetlib.dto.response.CustomSolrResponse;
import eu.dnetlib.services.ProjectService;
import eu.dnetlib.services.ResearchProductService;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/browseAll"})
public class SpecialController
extends EntityController {
    Logger log = LogManager.getLogger(SpecialController.class);
    @Autowired
    ProjectService projectService;
    @Autowired
    ResearchProductService researchProductService;

    @GetMapping(value={"/researchProducts/relfunder"}, produces={"application/json"})
    public CustomSolrResponse browseResearchProductsFunders(ResearchProductRequest researchProductRequest) {
        FacetRequest facetRequest = new FacetRequest();
        facetRequest.setFacetFields(List.of("relfunder"));
        researchProductRequest.setPage(Integer.valueOf(0));
        researchProductRequest.setSize(Integer.valueOf(0));
        return this.researchProductService.internalFacetSearch(researchProductRequest, facetRequest);
    }

    @GetMapping(value={"/researchProducts/relfundinglevel0_id"}, produces={"application/json"})
    public CustomSolrResponse browseResearchProductsFundingLevel0(ResearchProductRequest researchProductRequest) {
        FacetRequest facetRequest = new FacetRequest();
        facetRequest.setFacetFields(List.of("relfundinglevel0_id"));
        researchProductRequest.setPage(Integer.valueOf(0));
        researchProductRequest.setSize(Integer.valueOf(0));
        return this.researchProductService.internalFacetSearch(researchProductRequest, facetRequest);
    }

    @GetMapping(value={"/researchProducts/relfundinglevel1_id"}, produces={"application/json"})
    public CustomSolrResponse browseResearchProductsFundingLevel1(ResearchProductRequest researchProductRequest) {
        FacetRequest facetRequest = new FacetRequest();
        facetRequest.setFacetFields(List.of("relfundinglevel1_id"));
        researchProductRequest.setPage(Integer.valueOf(0));
        researchProductRequest.setSize(Integer.valueOf(0));
        return this.researchProductService.internalFacetSearch(researchProductRequest, facetRequest);
    }

    @GetMapping(value={"/researchProducts/relfundinglevel2_id"}, produces={"application/json"})
    public CustomSolrResponse browseResearchProductsFundingLevel2(ResearchProductRequest researchProductRequest) {
        FacetRequest facetRequest = new FacetRequest();
        facetRequest.setFacetFields(List.of("relfundinglevel2_id"));
        researchProductRequest.setPage(Integer.valueOf(0));
        researchProductRequest.setSize(Integer.valueOf(0));
        return this.researchProductService.internalFacetSearch(researchProductRequest, facetRequest);
    }

    @GetMapping(value={"/projects/funder"}, produces={"application/json"})
    public CustomSolrResponse browseProjectFunders(ProjectRequest projectRequest) {
        FacetRequest facetRequest = new FacetRequest();
        facetRequest.setFacetFields(List.of("funder"));
        projectRequest.setPage(Integer.valueOf(0));
        projectRequest.setSize(Integer.valueOf(0));
        return this.projectService.internalFacetSearch(projectRequest, facetRequest);
    }

    @GetMapping(value={"/projects/fundinglevel0_id"}, produces={"application/json"})
    public CustomSolrResponse browseProjectFundingLevel0(ProjectRequest projectRequest) {
        FacetRequest facetRequest = new FacetRequest();
        facetRequest.setFacetFields(List.of("fundinglevel0_id"));
        projectRequest.setPage(Integer.valueOf(0));
        projectRequest.setSize(Integer.valueOf(0));
        return this.projectService.internalFacetSearch(projectRequest, facetRequest);
    }

    @GetMapping(value={"/projects/fundinglevel1_id"}, produces={"application/json"})
    public CustomSolrResponse browseProjectFundingLevel1(ProjectRequest projectRequest) {
        FacetRequest facetRequest = new FacetRequest();
        facetRequest.setFacetFields(List.of("fundinglevel1_id"));
        projectRequest.setPage(Integer.valueOf(0));
        projectRequest.setSize(Integer.valueOf(0));
        return this.projectService.internalFacetSearch(projectRequest, facetRequest);
    }

    @GetMapping(value={"/projects/fundinglevel2_id"}, produces={"application/json"})
    public CustomSolrResponse browseProjectFundingLevel2(ProjectRequest projectRequest) {
        FacetRequest facetRequest = new FacetRequest();
        facetRequest.setFacetFields(List.of("fundinglevel2_id"));
        projectRequest.setPage(Integer.valueOf(0));
        projectRequest.setSize(Integer.valueOf(0));
        return this.projectService.internalFacetSearch(projectRequest, facetRequest);
    }

    @GetMapping(value={"/researcher-works"}, produces={"application/json"})
    public CustomSolrResponse fetchAllWorksByAuthorOrcid(@RequestParam String orcid) {
        ResearchProductRequest researchProductRequest = new ResearchProductRequest();
        researchProductRequest.setAuthorOrcid(new String[]{orcid});
        return this.researchProductService.cursorSearch(researchProductRequest);
    }

    @GetMapping(value={"/researcherWorks"}, produces={"application/octet-stream"})
    public void streamAllWorksByAuthorOrcid(@RequestParam String orcid, HttpServletResponse response) {
        ResearchProductRequest researchProductRequest = new ResearchProductRequest();
        researchProductRequest.setAuthorOrcid(new String[]{orcid});
        response.setHeader("Content-Disposition", "attachment; filename=\"researcher_works.json\"");
        response.setContentType("application/octet-stream");
        try (ServletOutputStream outputStream = response.getOutputStream();){
            this.researchProductService.cursorSearchStream(researchProductRequest, (OutputStream)outputStream);
        }
        catch (IOException e) {
            this.log.error("Error streaming researcher works for ORCID: {}.", (Object)orcid, (Object)e);
            response.setStatus(500);
        }
    }
}

