/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.mappers.solr;

import eu.dnetlib.dto.request.DatasourceRequest;
import eu.dnetlib.dto.request.EntityRequest;
import eu.dnetlib.dto.request.FacetRequest;
import eu.dnetlib.dto.request.OrganizationRequest;
import eu.dnetlib.dto.request.PersonRequest;
import eu.dnetlib.dto.request.ProjectRequest;
import eu.dnetlib.dto.request.ResearchProductRequest;
import eu.dnetlib.dto.request.ServiceRequest;
import eu.dnetlib.mappers.request.DatasourceRequestMapper;
import eu.dnetlib.mappers.request.OrganizationRequestMapper;
import eu.dnetlib.mappers.request.PersonRequestMapper;
import eu.dnetlib.mappers.request.ProjectRequestMapper;
import eu.dnetlib.mappers.request.ResearchProductRequestMapper;
import eu.dnetlib.mappers.request.ServiceRequestMapper;
import eu.dnetlib.solr.BasicSolrQuery;
import eu.dnetlib.solr.CustomSolrParams;
import eu.dnetlib.solr.SortParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.SolrQuery;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.Mappings;
import org.mapstruct.factory.Mappers;

@Mapper(componentModel="spring", uses={OrganizationRequestMapper.class, DatasourceRequestMapper.class, ProjectRequest.class})
public interface CustomSolrParamsMapper {
    @Mappings(value={@Mapping(target="basicSolrQuery", expression="java(mapBasicSolrQuery(entityRequest))"), @Mapping(target="facetFields", source="facetRequest.facetFields"), @Mapping(target="start", expression="java(entityRequest.getPage() * entityRequest.getSize())"), @Mapping(target="rows", source="entityRequest.size"), @Mapping(target="facet", source="facetRequest.facet"), @Mapping(target="mincount", constant="1"), @Mapping(target="offset", constant="0"), @Mapping(target="facetLimit", source="facetlimit"), @Mapping(target="sort", expression="java(mapSort(entityRequest))")})
    public CustomSolrParams toCustomSolrParams(EntityRequest var1, FacetRequest var2, Integer var3);

    @Mappings(value={@Mapping(target="basicSolrQuery", expression="java(mapBasicSolrQuery(entityRequest))"), @Mapping(target="facetFields", source="facetRequest.facetFields"), @Mapping(target="start", expression="java(entityRequest.getPage() * entityRequest.getSize())"), @Mapping(target="rows", source="entityRequest.size"), @Mapping(target="facet", source="facetRequest.facet"), @Mapping(target="mincount", constant="1"), @Mapping(target="offset", constant="0"), @Mapping(target="facetLimit", constant="-1"), @Mapping(target="sort", expression="java(mapSort(entityRequest))")})
    public CustomSolrParams toCustomSolrParamsForBrowseAll(EntityRequest var1, FacetRequest var2);

    @Mappings(value={@Mapping(target="basicSolrQuery", expression="java(mapBasicSolrQuery(entityRequest))"), @Mapping(target="start", expression="java(entityRequest.getPage() * entityRequest.getSize())"), @Mapping(target="rows", source="entityRequest.size"), @Mapping(target="facet", constant="false"), @Mapping(target="mincount", constant="1"), @Mapping(target="offset", constant="0"), @Mapping(target="facetLimit", constant="10"), @Mapping(target="sort", expression="java(mapSort(entityRequest))")})
    public CustomSolrParams toCustomSolrParams(EntityRequest var1);

    @Mappings(value={@Mapping(target="basicSolrQuery", expression="java(mapBasicSolrOrQuery(entityRequest))"), @Mapping(target="start", expression="java(entityRequest.getPage() * entityRequest.getSize())"), @Mapping(target="rows", source="entityRequest.size"), @Mapping(target="facet", constant="false"), @Mapping(target="mincount", constant="1"), @Mapping(target="offset", constant="0"), @Mapping(target="facetLimit", constant="10"), @Mapping(target="sort", expression="java(mapSort(entityRequest))")})
    public CustomSolrParams toCustomSolrOrParams(EntityRequest var1);

    @Mappings(value={@Mapping(target="basicSolrQuery", expression="java(mapBasicIdSolrQuery(entityRequest))"), @Mapping(target="start", constant="0"), @Mapping(target="rows", constant="1"), @Mapping(target="facet", constant="false"), @Mapping(target="sort", expression="java(mapSort(entityRequest))")})
    public CustomSolrParams toCustomIdSolrParams(EntityRequest var1);

    @Mappings(value={@Mapping(target="basicSolrQuery", expression="java(mapBasicSolrQuery(entityRequest))"), @Mapping(target="start", constant="0"), @Mapping(target="rows", constant="500"), @Mapping(target="facet", constant="false"), @Mapping(target="shards.tolerant", constant="true"), @Mapping(target="cursorMark", expression="java(mapCursorMark(entityRequest))"), @Mapping(target="sort", expression="java(mapSortForCursor(entityRequest))")})
    public CustomSolrParams toCustomCursorSolrParams(EntityRequest var1);

    default public String mapQueryToQueryString(String query) {
        return query != null ? query : "*:*";
    }

    default public BasicSolrQuery mapBasicSolrQuery(EntityRequest entityRequest) {
        if (entityRequest instanceof OrganizationRequest) {
            return ((OrganizationRequestMapper)Mappers.getMapper(OrganizationRequestMapper.class)).toBasicSolrQuery((OrganizationRequest)entityRequest);
        }
        if (entityRequest instanceof DatasourceRequest) {
            return ((DatasourceRequestMapper)Mappers.getMapper(DatasourceRequestMapper.class)).toBasicSolrQuery((DatasourceRequest)entityRequest);
        }
        if (entityRequest instanceof ServiceRequest) {
            return ((ServiceRequestMapper)Mappers.getMapper(ServiceRequestMapper.class)).toBasicSolrQuery((ServiceRequest)entityRequest);
        }
        if (entityRequest instanceof ProjectRequest) {
            return ((ProjectRequestMapper)Mappers.getMapper(ProjectRequestMapper.class)).toBasicSolrQuery((ProjectRequest)entityRequest);
        }
        if (entityRequest instanceof ResearchProductRequest) {
            return ((ResearchProductRequestMapper)Mappers.getMapper(ResearchProductRequestMapper.class)).toBasicSolrQuery((ResearchProductRequest)entityRequest);
        }
        if (entityRequest instanceof PersonRequest) {
            return ((PersonRequestMapper)Mappers.getMapper(PersonRequestMapper.class)).toBasicSolrQuery((PersonRequest)entityRequest);
        }
        return null;
    }

    default public BasicSolrQuery mapBasicSolrOrQuery(EntityRequest entityRequest) {
        if (entityRequest instanceof OrganizationRequest) {
            return ((OrganizationRequestMapper)Mappers.getMapper(OrganizationRequestMapper.class)).toBasicSolrQuery((OrganizationRequest)entityRequest);
        }
        if (entityRequest instanceof DatasourceRequest) {
            return ((DatasourceRequestMapper)Mappers.getMapper(DatasourceRequestMapper.class)).toBasicSolrQuery((DatasourceRequest)entityRequest);
        }
        if (entityRequest instanceof ProjectRequest) {
            return ((ProjectRequestMapper)Mappers.getMapper(ProjectRequestMapper.class)).toBasicSolrQuery((ProjectRequest)entityRequest);
        }
        if (entityRequest instanceof ResearchProductRequest) {
            return ((ResearchProductRequestMapper)Mappers.getMapper(ResearchProductRequestMapper.class)).toBasicSolrOrQuery((ResearchProductRequest)entityRequest);
        }
        if (entityRequest instanceof PersonRequest) {
            return ((PersonRequestMapper)Mappers.getMapper(PersonRequestMapper.class)).toBasicSolrQuery((PersonRequest)entityRequest);
        }
        return null;
    }

    default public BasicSolrQuery mapBasicIdSolrQuery(EntityRequest entityRequest) {
        if (entityRequest instanceof OrganizationRequest) {
            return ((OrganizationRequestMapper)Mappers.getMapper(OrganizationRequestMapper.class)).toBasicIdSolrQuery((OrganizationRequest)entityRequest);
        }
        if (entityRequest instanceof ProjectRequest) {
            return ((ProjectRequestMapper)Mappers.getMapper(ProjectRequestMapper.class)).toBasicIdSolrQuery((ProjectRequest)entityRequest);
        }
        if (entityRequest instanceof DatasourceRequest) {
            return ((DatasourceRequestMapper)Mappers.getMapper(DatasourceRequestMapper.class)).toBasicIdSolrQuery((DatasourceRequest)entityRequest);
        }
        if (entityRequest instanceof ServiceRequest) {
            return ((ServiceRequestMapper)Mappers.getMapper(ServiceRequestMapper.class)).toBasicIdSolrQuery((ServiceRequest)entityRequest);
        }
        if (entityRequest instanceof ResearchProductRequest) {
            return ((ResearchProductRequestMapper)Mappers.getMapper(ResearchProductRequestMapper.class)).toBasicIdSolrQuery((ResearchProductRequest)entityRequest);
        }
        if (entityRequest instanceof PersonRequest) {
            return ((PersonRequestMapper)Mappers.getMapper(PersonRequestMapper.class)).toBasicIdSolrQuery((PersonRequest)entityRequest);
        }
        return null;
    }

    default public List<SolrQuery.SortClause> mapSort(EntityRequest entityRequest) {
        if (entityRequest instanceof OrganizationRequest) {
            return this.parseSortClauses(((OrganizationRequestMapper)Mappers.getMapper(OrganizationRequestMapper.class)).extractSortParams((OrganizationRequest)entityRequest), false);
        }
        if (entityRequest instanceof ProjectRequest) {
            return this.parseSortClauses(((ProjectRequestMapper)Mappers.getMapper(ProjectRequestMapper.class)).extractSortParams((ProjectRequest)entityRequest), false);
        }
        if (entityRequest instanceof DatasourceRequest) {
            return this.parseSortClauses(((DatasourceRequestMapper)Mappers.getMapper(DatasourceRequestMapper.class)).extractSortParams((DatasourceRequest)entityRequest), false);
        }
        if (entityRequest instanceof ServiceRequest) {
            return this.parseSortClauses(((ServiceRequestMapper)Mappers.getMapper(ServiceRequestMapper.class)).extractSortParams((ServiceRequest)entityRequest), false);
        }
        if (entityRequest instanceof ResearchProductRequest) {
            return this.parseSortClauses(((ResearchProductRequestMapper)Mappers.getMapper(ResearchProductRequestMapper.class)).extractSortParams((ResearchProductRequest)entityRequest), false);
        }
        if (entityRequest instanceof PersonRequest) {
            return this.parseSortClauses(((PersonRequestMapper)Mappers.getMapper(PersonRequestMapper.class)).extractSortParams((PersonRequest)entityRequest), false);
        }
        return null;
    }

    default public List<SolrQuery.SortClause> mapSortForCursor(EntityRequest entityRequest) {
        if (entityRequest instanceof OrganizationRequest) {
            return this.parseSortClauses(((OrganizationRequestMapper)Mappers.getMapper(OrganizationRequestMapper.class)).extractSort((OrganizationRequest)entityRequest), true);
        }
        if (entityRequest instanceof ProjectRequest) {
            return this.parseSortClauses(((ProjectRequestMapper)Mappers.getMapper(ProjectRequestMapper.class)).extractSortParams((ProjectRequest)entityRequest), true);
        }
        if (entityRequest instanceof DatasourceRequest) {
            return this.parseSortClauses(((DatasourceRequestMapper)Mappers.getMapper(DatasourceRequestMapper.class)).extractSortParams((DatasourceRequest)entityRequest), true);
        }
        if (entityRequest instanceof ServiceRequest) {
            return this.parseSortClauses(((ServiceRequestMapper)Mappers.getMapper(ServiceRequestMapper.class)).extractSortParams((ServiceRequest)entityRequest), false);
        }
        if (entityRequest instanceof ResearchProductRequest) {
            return this.parseSortClauses(((ResearchProductRequestMapper)Mappers.getMapper(ResearchProductRequestMapper.class)).extractSortParams((ResearchProductRequest)entityRequest), true);
        }
        if (entityRequest instanceof PersonRequest) {
            return this.parseSortClauses(((PersonRequestMapper)Mappers.getMapper(PersonRequestMapper.class)).extractSortParams((PersonRequest)entityRequest), true);
        }
        return null;
    }

    default public String mapCursorMark(EntityRequest entityRequest) {
        if (entityRequest.getCursorMark() == null || entityRequest.getCursorMark().isEmpty()) {
            return "*";
        }
        return entityRequest.getCursorMark();
    }

    private List<SolrQuery.SortClause> parseSortClauses(SortParam sort, boolean isCursor) {
        ArrayList<SolrQuery.SortClause> sortClauses = new ArrayList<SolrQuery.SortClause>();
        for (Map.Entry entry : sort.getSort().entrySet()) {
            String field = (String)entry.getKey();
            SolrQuery.ORDER order = ((String)entry.getValue()).equalsIgnoreCase("ASC") ? SolrQuery.ORDER.asc : SolrQuery.ORDER.desc;
            sortClauses.add(new SolrQuery.SortClause(field, order));
        }
        if (isCursor) {
            sortClauses.add(new SolrQuery.SortClause("__indexrecordidentifier", SolrQuery.ORDER.asc));
        }
        return sortClauses;
    }

    private List<SolrQuery.SortClause> parseSortClauses(List<SortParam> sortParams, boolean isCursor) {
        ArrayList<SolrQuery.SortClause> sortClauses = new ArrayList<SolrQuery.SortClause>();
        if (sortParams == null || sortParams.isEmpty()) {
            sortClauses.add(new SolrQuery.SortClause("score", SolrQuery.ORDER.desc));
        } else {
            for (SortParam sortParam : sortParams) {
                for (Map.Entry entry : sortParam.getSort().entrySet()) {
                    String field = (String)entry.getKey();
                    SolrQuery.ORDER order = ((String)entry.getValue()).equalsIgnoreCase("ASC") ? SolrQuery.ORDER.asc : SolrQuery.ORDER.desc;
                    sortClauses.add(new SolrQuery.SortClause(field, order));
                }
            }
        }
        sortClauses.add(new SolrQuery.SortClause("__indexrecordidentifier", SolrQuery.ORDER.asc));
        return sortClauses;
    }
}

