/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.irishmonitorservice.security;

import eu.dnetlib.authentication.security.OpenAIREAuthoritiesMapper;
import eu.dnetlib.uoaauthorizationlibrary.authorization.security.AuthorizationService;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.core.oidc.user.OidcUser;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(value={"authentication.authorities-mapper"}, havingValue="irish.eduperson_entitlement")
public class IrishAuthoritiesMapper
extends OpenAIREAuthoritiesMapper {
    private final String domain = "IRISH_";
    private final AuthorizationService authorizationService;

    @Autowired
    public IrishAuthoritiesMapper(AuthorizationService authorizationService) {
        this.authorizationService = authorizationService;
    }

    public Collection<? extends GrantedAuthority> mapAuthorities(OidcUser oidcUser) {
        return super.mapAuthorities(oidcUser).stream().filter(arg_0 -> this.filter(arg_0)).map(arg_0 -> this.map(arg_0)).collect(Collectors.toSet());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean filter(GrantedAuthority authority) {
        String string = authority.getAuthority();
        Objects.requireNonNull(this.authorizationService);
        if (string.equals("PORTAL_ADMINISTRATOR")) return true;
        String string2 = authority.getAuthority();
        Objects.requireNonNull(this.authorizationService);
        if (string2.equals("REGISTERED_USER")) return true;
        if (!authority.getAuthority().contains("IRISH_")) return false;
        return true;
    }

    public GrantedAuthority map(GrantedAuthority authority) {
        return new SimpleGrantedAuthority(authority.getAuthority().replaceFirst("IRISH_", ""));
    }
}

