/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.irishmonitorservice.services;

import eu.dnetlib.irishmonitorservice.services.StatsToolService;
import java.io.UnsupportedEncodingException;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class CacheService {
    private final Logger logger = LogManager.getLogger(CacheService.class);
    private final StatsToolService statsToolService;
    private final CacheManager cacheManager;

    @Autowired
    public CacheService(StatsToolService statsToolService, CacheManager cacheManager) throws UnsupportedEncodingException {
        this.statsToolService = statsToolService;
        this.cacheManager = cacheManager;
        this.clearCache();
    }

    public List<List<List<String>>> getResponse(String type) throws UnsupportedEncodingException {
        return switch (type) {
            case "funder" -> this.statsToolService.getFunders();
            case "organization" -> this.statsToolService.getOrganizations();
            case "datasource" -> this.statsToolService.getDataSources();
            default -> null;
        };
    }

    @Scheduled(cron="0 0 0 * * *")
    public void clearCache() {
        this.cacheManager.getCache("funder");
        this.cacheManager.getCache("organization");
        this.cacheManager.getCache("datasource");
        this.cacheManager.getCacheNames().stream().map(arg_0 -> ((CacheManager)this.cacheManager).getCache(arg_0)).filter(Objects::nonNull).forEach(Cache::clear);
        this.logger.info("Cache cleared at " + String.valueOf(LocalDateTime.now()));
        this.statsToolService.getFunders();
        this.statsToolService.getOrganizations();
        this.statsToolService.getDataSources();
    }
}

