package eu.dnetlib.msro.openaireplus.workflows.nodes;

import java.io.StringReader;
import java.util.Set;

import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.springframework.beans.factory.annotation.Autowired;

import com.googlecode.sarasvati.Arc;
import com.googlecode.sarasvati.NodeToken;

import eu.dnetlib.enabling.datasources.LocalOpenaireDatasourceManager;
import eu.dnetlib.enabling.resultset.MappedResultSetFactory;
import eu.dnetlib.enabling.resultset.client.utils.EPRUtils;
import eu.dnetlib.msro.workflows.nodes.SimpleJobNode;

public class FilterManagedDatasourcesJobNode extends SimpleJobNode {

	private static final Log log = LogFactory.getLog(FilterManagedDatasourcesJobNode.class);

	private String inputEprParam;
	private String outputEprParam;

	@Autowired
	private LocalOpenaireDatasourceManager dsManager;

	@Autowired
	private MappedResultSetFactory mappedResultSetFactory;

	@Override
	protected String execute(final NodeToken token) throws Exception {
		final W3CEndpointReference inputEpr = new EPRUtils().getEpr(token.getEnv().getAttribute(getInputEprParam()));

		final Set<String> managedDatasources = dsManager.listManagedDatasourceIds();

		log.info(String.format("found %s managed datasources", managedDatasources.size()));

		final W3CEndpointReference outputEpr = mappedResultSetFactory.createMappedResultSet(inputEpr, s -> filterManaged(s, managedDatasources));

		token.getEnv().setAttribute(getOutputEprParam(), outputEpr.toString());

		return Arc.DEFAULT_ARC;
	}

	/**
	 * Extracts the datasource id from the input record and checks its existence in the given set.
	 *
	 * @param data
	 * @param filter
	 * @return The
	 * @throws IllegalStateException
	 */
	private String filterManaged(final String data, final Set<String> filter) throws IllegalStateException {
		try {
			final Document doc = new SAXReader().read(new StringReader(data));

			final String dsId = doc.valueOf("/record/metadata/ROWS/ROW[@table = 'dsm_services']/FIELD[@name = 'id']/text()");
			if (filter.contains(dsId)) {
				doc.selectSingleNode("/record/metadata/ROWS").detach();
				((Element) doc.selectSingleNode("/record/metadata")).addElement("ROWS");
				return doc.asXML();
			} else {
				return data;
			}
		} catch (final DocumentException e) {
			throw new IllegalStateException(e);
		}
	}

	public String getInputEprParam() {
		return inputEprParam;
	}

	public void setInputEprParam(final String inputEprParam) {
		this.inputEprParam = inputEprParam;
	}

	public String getOutputEprParam() {
		return outputEprParam;
	}

	public void setOutputEprParam(final String outputEprParam) {
		this.outputEprParam = outputEprParam;
	}

}
